/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers.interactive;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class VirtualTableView
extends ViewPart {
    TableViewer viewer;
    int itemCount = 10000;

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 0x10000000);
        this.viewer.setContentProvider(this.getContentProvider());
        this.viewer.setInput((Object)this);
        this.viewer.setItemCount(this.itemCount);
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout());
        Button resetInput = new Button(buttonComposite, 8);
        resetInput.setText("Reset input");
        resetInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VirtualTableView.this.resetInput();
            }
        });
        Button delete = new Button(buttonComposite, 8);
        delete.setText("Delete selection");
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selection = VirtualTableView.this.viewer.getStructuredSelection().toArray();
                VirtualTableView.this.doRemove(selection);
            }
        });
    }

    protected final void doRemove(Object[] selection) {
        this.viewer.remove(selection);
    }

    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Object[] elements = new String[VirtualTableView.this.itemCount];
                int i = 0;
                while (i < VirtualTableView.this.itemCount) {
                    elements[i] = "Element " + i;
                    ++i;
                }
                return elements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    protected void resetInput() {
        this.viewer.setInput((Object)this);
    }
}

