/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.widgets;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.tests.widgets.AbstractFactoryTest;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class TestUnitControlFactory
extends AbstractFactoryTest {
    @Test
    public void createsControlWithNullsWhenNothingSet() {
        Label testLabel = (Label)LabelFactory.newLabel((int)0).create((Widget)shell);
        Assert.assertTrue((boolean)testLabel.getEnabled());
        Assert.assertNull((Object)testLabel.getLayoutData());
        Assert.assertNull((Object)testLabel.getToolTipText());
        Assert.assertEquals((Object)testLabel, (Object)shell.getChildren()[0]);
    }

    @Test
    public void setsTooltip() {
        Label label = (Label)((LabelFactory)LabelFactory.newLabel((int)0).tooltip("toolTip")).create((Widget)shell);
        Assert.assertEquals((Object)"toolTip", (Object)label.getToolTipText());
    }

    @Test
    public void setsEnabled() {
        Label label = (Label)((LabelFactory)LabelFactory.newLabel((int)0).enabled(false)).create((Widget)shell);
        Assert.assertFalse((boolean)label.getEnabled());
    }

    @Test
    public void setsLayoutData() {
        Label label = (Label)((LabelFactory)LabelFactory.newLabel((int)0).layoutData((Object)new GridData(1808))).create((Widget)shell);
        Assert.assertTrue((boolean)(label.getLayoutData() instanceof GridData));
    }

    @Test
    public void createsControlWithProperties() {
        Font font = new Font(null, new FontData());
        Label label = (Label)((LabelFactory)LabelFactory.newLabel((int)0).font(font)).create((Widget)shell);
        Assert.assertEquals((Object)font, (Object)label.getFont());
    }

    @Test
    public void testUniqueLayoutData() {
        GridDataFactory gridDataFactory = GridDataFactory.fillDefaults().grab(true, false);
        LabelFactory factory = (LabelFactory)LabelFactory.newLabel((int)0).supplyLayoutData(() -> ((GridDataFactory)gridDataFactory).create());
        Label label = (Label)factory.create((Widget)shell);
        Label label2 = (Label)factory.create((Widget)shell);
        Assert.assertNotSame((Object)label.getLayoutData(), (Object)label2.getLayoutData());
    }

    @Test
    public void setsForeground() {
        Color color = new Color(null, 255, 255, 255);
        Label label = (Label)((LabelFactory)LabelFactory.newLabel((int)0).foreground(color)).create((Widget)shell);
        Assert.assertEquals((Object)color, (Object)label.getForeground());
    }

    @Test
    public void setsBackground() {
        Color color = new Color(null, 0, 0, 0);
        Label label = (Label)((LabelFactory)LabelFactory.newLabel((int)0).background(color)).create((Widget)shell);
        Assert.assertEquals((Object)color, (Object)label.getBackground());
    }

    @Test
    public void setsOrientation() {
        Label label = (Label)((LabelFactory)LabelFactory.newLabel((int)0).orientation(0x2000000)).create((Widget)shell);
        Assert.assertEquals((long)0x2000000L, (long)label.getOrientation());
    }
}

