/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.widgets;

import org.eclipse.jface.tests.widgets.AbstractFactoryTest;
import org.eclipse.jface.widgets.ShellFactory;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class TestUnitShellFactory
extends AbstractFactoryTest {
    @Test
    public void createsShell() {
        Shell myShell = (Shell)ShellFactory.newShell((int)2048).create((Widget)shell);
        Assert.assertEquals((Object)shell, (Object)myShell.getParent());
    }

    @Test
    public void createsShellInDisplayWithText() {
        Display display = Display.getDefault();
        Shell myShell = ShellFactory.newShell((int)2048).text("Test").create(display);
        Assert.assertEquals((Object)"Test", (Object)myShell.getText());
        Assert.assertNull((Object)myShell.getParent());
        Assert.assertEquals((Object)display, (Object)myShell.getDisplay());
    }

    @Test
    public void createsShellWithAllProperties() {
        Shell myShell = (Shell)((ShellFactory)ShellFactory.newShell((int)2048).text("Test").enabled(false)).create((Widget)shell);
        Assert.assertEquals((Object)"Test", (Object)myShell.getText());
        Assert.assertFalse((boolean)myShell.getEnabled());
    }

    @Test
    public void createsShellWithMenuBar() {
        Menu[] menu = new Menu[1];
        Shell myShell = (Shell)ShellFactory.newShell((int)2048).menuBar(shell -> {
            menuArray[0] = new Menu(shell, 2);
            return menu[0];
        }).create((Widget)TestUnitShellFactory.shell);
        Assert.assertEquals((Object)menu[0], (Object)myShell.getMenuBar());
    }

    @Test
    public void createsMinimizedShell() {
        Shell myShell = (Shell)ShellFactory.newShell((int)2048).minimized(true).create((Widget)shell);
        Assert.assertTrue((boolean)myShell.getMinimized());
    }

    @Test
    public void createsMaximizedShell() {
        Shell myShell = (Shell)ShellFactory.newShell((int)2048).maximized(true).create((Widget)shell);
        Assert.assertTrue((boolean)myShell.getMaximized());
    }

    @Test
    public void createsFullScreenShell() {
        Shell myShell = (Shell)ShellFactory.newShell((int)2048).fullScreen(true).create((Widget)shell);
        Assert.assertTrue((boolean)myShell.getFullScreen());
    }

    @Test
    public void addsShellActivatedListener() {
        ShellEvent[] raisedEvents = new ShellEvent[1];
        Shell myShell = (Shell)ShellFactory.newShell((int)2048).onActivate(e -> {
            ShellEvent shellEvent = e;
        }).create((Widget)shell);
        myShell.notifyListeners(26, new Event());
        Assert.assertEquals((long)1L, (long)myShell.getListeners(26).length);
        Assert.assertNotNull((Object)raisedEvents[0]);
    }

    @Test
    public void addsShellDeactivatedListener() {
        ShellEvent[] raisedEvents = new ShellEvent[1];
        Shell myShell = (Shell)ShellFactory.newShell((int)2048).onDeactivate(e -> {
            ShellEvent shellEvent = e;
        }).create((Widget)shell);
        myShell.notifyListeners(27, new Event());
        Assert.assertEquals((long)1L, (long)myShell.getListeners(27).length);
        Assert.assertNotNull((Object)raisedEvents[0]);
    }

    @Test
    public void addsShellIconfiedListener() {
        ShellEvent[] raisedEvents = new ShellEvent[1];
        Shell myShell = (Shell)ShellFactory.newShell((int)2048).onIconify(e -> {
            ShellEvent shellEvent = e;
        }).create((Widget)shell);
        myShell.notifyListeners(19, new Event());
        Assert.assertEquals((long)1L, (long)myShell.getListeners(19).length);
        Assert.assertNotNull((Object)raisedEvents[0]);
    }

    @Test
    public void addsShellDeiconfiedListener() {
        ShellEvent[] raisedEvents = new ShellEvent[1];
        Shell myShell = (Shell)ShellFactory.newShell((int)2048).onDeiconify(e -> {
            ShellEvent shellEvent = e;
        }).create((Widget)shell);
        myShell.notifyListeners(20, new Event());
        Assert.assertEquals((long)1L, (long)myShell.getListeners(20).length);
        Assert.assertNotNull((Object)raisedEvents[0]);
    }

    @Test
    public void addsShellClosedListener() {
        ShellEvent[] raisedEvents = new ShellEvent[1];
        Shell myShell = (Shell)ShellFactory.newShell((int)2048).onClose(e -> {
            ShellEvent shellEvent = e;
        }).create((Widget)shell);
        myShell.notifyListeners(21, new Event());
        Assert.assertEquals((long)1L, (long)myShell.getListeners(21).length);
        Assert.assertNotNull((Object)raisedEvents[0]);
    }
}

