/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.widgets;

import org.eclipse.jface.tests.widgets.AbstractFactoryTest;
import org.eclipse.jface.widgets.SpinnerFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class TestUnitSpinnerFactory
extends AbstractFactoryTest {
    @Test
    public void createsSpinner() {
        Spinner spinner = (Spinner)SpinnerFactory.newSpinner((int)8).create((Widget)shell);
        Assert.assertEquals((Object)shell, (Object)spinner.getParent());
        Assert.assertEquals((long)8L, (long)(spinner.getStyle() & 8));
    }

    @Test
    public void createsSpinnerWithAllProperties() {
        TypedEvent[] raisedEvents = new TypedEvent[2];
        Spinner spinner = (Spinner)SpinnerFactory.newSpinner((int)0).bounds(20, 120).increment(2, 10).limitTo(3).onSelect(e -> {
            SelectionEvent selectionEvent = e;
        }).onModify(e -> {
            ModifyEvent modifyEvent = e;
        }).create((Widget)shell);
        spinner.notifyListeners(13, new Event());
        spinner.notifyListeners(24, new Event());
        Assert.assertEquals((long)2L, (long)spinner.getIncrement());
        Assert.assertEquals((long)10L, (long)spinner.getPageIncrement());
        Assert.assertEquals((long)20L, (long)spinner.getMinimum());
        Assert.assertEquals((long)120L, (long)spinner.getMaximum());
        Assert.assertEquals((long)3L, (long)spinner.getTextLimit());
        Assert.assertEquals((long)1L, (long)spinner.getListeners(13).length);
        Assert.assertNotNull((Object)raisedEvents[0]);
        Assert.assertEquals((long)1L, (long)spinner.getListeners(24).length);
        Assert.assertNotNull((Object)raisedEvents[1]);
    }
}

