/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.widgets;

import org.eclipse.jface.tests.widgets.AbstractFactoryTest;
import org.eclipse.jface.widgets.TableColumnFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestUnitTableColumnFactory
extends AbstractFactoryTest {
    private Table table;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.table = (Table)WidgetFactory.table((int)0).create((Widget)shell);
    }

    @Test
    public void createsTableColumn() {
        TableColumn tableColumn = (TableColumn)TableColumnFactory.newTableColumn((int)0x1000000).create((Widget)this.table);
        Assert.assertEquals((Object)this.table.getColumn(0), (Object)tableColumn);
        Assert.assertEquals((Object)tableColumn.getParent(), (Object)this.table);
        Assert.assertEquals((long)0x1000000L, (long)(tableColumn.getStyle() & 0x1000000));
    }

    @Test
    public void setsSelectionListener() {
        SelectionEvent[] raisedEvents = new SelectionEvent[1];
        TableColumn tableColumn = (TableColumn)TableColumnFactory.newTableColumn((int)0).onSelect(e -> {
            SelectionEvent selectionEvent = e;
        }).create((Widget)this.table);
        tableColumn.notifyListeners(13, new Event());
        Assert.assertEquals((long)1L, (long)tableColumn.getListeners(13).length);
        Assert.assertNotNull((Object)raisedEvents[0]);
    }

    @Test
    public void setsAlignment() {
        TableColumn tableColumn = (TableColumn)TableColumnFactory.newTableColumn((int)0).align(16384).create((Widget)this.table);
        Assert.assertEquals((long)16384L, (long)tableColumn.getAlignment());
    }

    @Test
    public void setsToolTip() {
        TableColumn tableColumn = (TableColumn)TableColumnFactory.newTableColumn((int)0).tooltip("tooltip").create((Widget)this.table);
        Assert.assertEquals((Object)"tooltip", (Object)tableColumn.getToolTipText());
    }

    @Test
    public void setsWidth() {
        TableColumn tableColumn = (TableColumn)TableColumnFactory.newTableColumn((int)0).width(10).create((Widget)this.table);
        Assert.assertEquals((long)10L, (long)tableColumn.getWidth());
    }

    @Test
    public void setsMoveable() {
        TableColumn column = (TableColumn)TableColumnFactory.newTableColumn((int)0).moveable(true).create((Widget)this.table);
        Assert.assertTrue((boolean)column.getMoveable());
    }

    @Test
    public void setsResizable() {
        TableColumn column = (TableColumn)TableColumnFactory.newTableColumn((int)0).resizable(true).create((Widget)this.table);
        Assert.assertTrue((boolean)column.getResizable());
    }
}

