/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.widgets;

import org.eclipse.jface.tests.widgets.AbstractFactoryTest;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class TestUnitTextFactory
extends AbstractFactoryTest {
    @Test
    public void createsText() {
        Text text = (Text)TextFactory.newText((int)2).create((Widget)shell);
        Assert.assertEquals((Object)shell, (Object)text.getParent());
        Assert.assertEquals((long)2L, (long)(text.getStyle() & 2));
    }

    @Test
    public void createsTextWithAllProperties() {
        TypedEvent[] raisedEvents = new TypedEvent[3];
        Text text = (Text)TextFactory.newText((int)0).text("Test Text").message("message").limitTo(10).onSelect(e -> {
            SelectionEvent selectionEvent = e;
        }).onModify(e -> {
            ModifyEvent modifyEvent = e;
        }).onVerify(e -> {
            VerifyEvent verifyEvent = e;
        }).create((Widget)shell);
        text.notifyListeners(13, new Event());
        text.notifyListeners(24, new Event());
        text.notifyListeners(25, new Event());
        Assert.assertEquals((Object)"Test Text", (Object)text.getText());
        Assert.assertEquals((Object)"message", (Object)text.getMessage());
        Assert.assertEquals((long)10L, (long)text.getTextLimit());
        Assert.assertEquals((long)1L, (long)text.getListeners(13).length);
        Assert.assertNotNull((Object)raisedEvents[0]);
        Assert.assertEquals((long)1L, (long)text.getListeners(24).length);
        Assert.assertNotNull((Object)raisedEvents[1]);
        Assert.assertEquals((long)1L, (long)text.getListeners(25).length);
        Assert.assertNotNull((Object)raisedEvents[2]);
    }
}

