/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.widgets;

import org.eclipse.jface.tests.widgets.AbstractFactoryTest;
import org.eclipse.jface.widgets.TreeColumnFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestUnitTreeColumnFactory
extends AbstractFactoryTest {
    private Tree tree;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.tree = (Tree)WidgetFactory.tree((int)0).create((Widget)shell);
    }

    @Test
    public void createsTreeColumn() {
        TreeColumn treeColumn = (TreeColumn)TreeColumnFactory.newTreeColumn((int)16384).create((Widget)this.tree);
        Assert.assertEquals((Object)this.tree.getColumn(0), (Object)treeColumn);
        Assert.assertEquals((Object)treeColumn.getParent(), (Object)this.tree);
        Assert.assertEquals((long)16384L, (long)(treeColumn.getStyle() & 0x4000));
    }

    @Test
    public void setsSelectionListener() {
        SelectionEvent[] raisedEvents = new SelectionEvent[1];
        TreeColumn treeColumn = (TreeColumn)TreeColumnFactory.newTreeColumn((int)0).onSelect(e -> {
            SelectionEvent selectionEvent = e;
        }).create((Widget)this.tree);
        treeColumn.notifyListeners(13, new Event());
        Assert.assertEquals((long)1L, (long)treeColumn.getListeners(13).length);
        Assert.assertNotNull((Object)raisedEvents[0]);
    }

    @Test
    public void setsAlignment() {
        TreeColumn treeColumn = (TreeColumn)TreeColumnFactory.newTreeColumn((int)0).align(16384).create((Widget)this.tree);
        Assert.assertEquals((long)16384L, (long)treeColumn.getAlignment());
    }

    @Test
    public void setsToolTip() {
        TreeColumn treeColumn = (TreeColumn)TreeColumnFactory.newTreeColumn((int)0).tooltip("tooltip").create((Widget)this.tree);
        Assert.assertEquals((Object)"tooltip", (Object)treeColumn.getToolTipText());
    }

    @Test
    public void setsWidth() {
        TreeColumn treeColumn = (TreeColumn)TreeColumnFactory.newTreeColumn((int)0).width(20).create((Widget)this.tree);
        Assert.assertEquals((long)20L, (long)treeColumn.getWidth());
    }

    @Test
    public void setsMoveable() {
        TreeColumn treeColumn = (TreeColumn)TreeColumnFactory.newTreeColumn((int)0).moveable(true).create((Widget)this.tree);
        Assert.assertTrue((boolean)treeColumn.getMoveable());
    }

    @Test
    public void setsResizable() {
        TreeColumn treeColumn = (TreeColumn)TreeColumnFactory.newTreeColumn((int)0).resizable(true).create((Widget)this.tree);
        Assert.assertTrue((boolean)treeColumn.getResizable());
    }
}

