/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.widgets;

import org.eclipse.jface.tests.widgets.AbstractFactoryTest;
import org.eclipse.jface.widgets.TreeFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class TestUnitTreeFactory
extends AbstractFactoryTest {
    @Test
    public void createsTree() {
        Tree tree = (Tree)TreeFactory.newTree((int)32).create((Widget)shell);
        Assert.assertEquals((Object)shell, (Object)tree.getParent());
        Assert.assertEquals((long)32L, (long)(tree.getStyle() & 0x20));
    }

    @Test
    public void createsTreeWithAllProperties() {
        SelectionEvent[] raisedEvents = new SelectionEvent[3];
        Tree tree = (Tree)TreeFactory.newTree((int)0).headerVisible(true).linesVisible(true).itemCount(42).onSelect(e -> {
            SelectionEvent selectionEvent = e;
        }).onExpand(e -> {
            TreeEvent treeEvent = e;
        }).onCollapse(e -> {
            TreeEvent treeEvent = e;
        }).create((Widget)shell);
        tree.notifyListeners(13, new Event());
        tree.notifyListeners(17, new Event());
        tree.notifyListeners(18, new Event());
        Assert.assertEquals((long)1L, (long)tree.getListeners(13).length);
        Assert.assertNotNull((Object)raisedEvents[0]);
        Assert.assertEquals((long)2L, (long)tree.getListeners(17).length);
        Assert.assertNotNull((Object)raisedEvents[1]);
        Assert.assertEquals((long)2L, (long)tree.getListeners(18).length);
        Assert.assertNotNull((Object)raisedEvents[2]);
        Assert.assertTrue((boolean)tree.getHeaderVisible());
        Assert.assertTrue((boolean)tree.getLinesVisible());
        Assert.assertEquals((long)42L, (long)tree.getItemCount());
    }
}

