/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.widgets;

import org.eclipse.jface.tests.widgets.AbstractFactoryTest;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class TestUnitWidgetFactory
extends AbstractFactoryTest {
    @Test
    public void createsWidgetWithNullsWhenNothingSet() {
        Label testLabel = (Label)LabelFactory.newLabel((int)0).create((Widget)shell);
        Assert.assertNull((Object)testLabel.getData());
        Assert.assertEquals((Object)testLabel, (Object)shell.getChildren()[0]);
    }

    @Test
    public void createsDifferentWidgetsWithSameFactory() {
        LabelFactory testFactory = LabelFactory.newLabel((int)0);
        Label label1 = (Label)testFactory.create((Widget)shell);
        Label label2 = (Label)testFactory.create((Widget)shell);
        Assert.assertNotSame((Object)label1, (Object)label2);
        Assert.assertEquals((Object)label1, (Object)shell.getChildren()[0]);
        Assert.assertEquals((Object)label2, (Object)shell.getChildren()[1]);
    }

    @Test
    public void setsData() {
        String data = "myData";
        Label testLabel = (Label)((LabelFactory)LabelFactory.newLabel((int)0).data((Object)data)).create((Widget)shell);
        Assert.assertEquals((Object)data, (Object)testLabel.getData());
    }

    @Test
    public void setsDataWithKey() {
        String data1 = "data1";
        String data2 = "data2";
        Label testLabel = (Label)((LabelFactory)((LabelFactory)LabelFactory.newLabel((int)0).data("id1", (Object)data1)).data("id2", (Object)data2)).create((Widget)shell);
        Assert.assertEquals((Object)data1, (Object)testLabel.getData("id1"));
        Assert.assertEquals((Object)data2, (Object)testLabel.getData("id2"));
    }
}

