/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.wizards;

import org.eclipse.jface.tests.wizards.TheTestWizard;
import org.eclipse.jface.tests.wizards.TheTestWizardDialog;
import org.eclipse.jface.tests.wizards.TheTestWizardPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ButtonAlignmentTest {
    private TheTestWizard wizard;
    private TheTestWizardDialog dialog;

    @Before
    public void setUp() throws Exception {
        Display.getDefault();
    }

    @After
    public void tearDown() throws Exception {
        if (this.dialog != null && this.dialog.getShell() != null && !this.dialog.getShell().isDisposed()) {
            this.dialog.close();
        }
    }

    @Test
    public void testButtonAlignment() {
        this.wizard = new TheTestWizard();
        this.dialog = new TheTestWizardDialog(null, (IWizard)this.wizard);
        this.dialog.create();
        this.dialog.open();
        Composite parent = this.dialog.getFinishedButton().getParent();
        Control[] children = parent.getChildren();
        Assert.assertEquals((String)"There should be three children, a composite for back/next buttons, the finish button, and the cancel button", (long)3L, (long)children.length);
        Assert.assertTrue((boolean)(children[0] instanceof Composite));
        Composite backNextParent = (Composite)children[0];
        Control[] backNextChildren = backNextParent.getChildren();
        Assert.assertEquals((String)"Back button should be the first button", (Object)this.dialog.getBackButton(), (Object)backNextChildren[0]);
        Assert.assertEquals((String)"Next button should be the second button", (Object)this.dialog.getNextButton(), (Object)backNextChildren[1]);
        int finishIndex = parent.getDisplay().getDismissalAlignment() == 16384 ? 1 : 2;
        int cancelIndex = parent.getDisplay().getDismissalAlignment() == 16384 ? 2 : 1;
        Assert.assertEquals((String)"Finish button's alignment is off", (Object)this.dialog.getFinishedButton(), (Object)children[finishIndex]);
        Assert.assertEquals((String)"Cancel button's alignment is off", (Object)this.dialog.getCancelButton(), (Object)children[cancelIndex]);
    }

    @Test
    public void testButtonAlignmentWithoutBackNextButtons() {
        this.wizard = new TheTestWizard(){

            @Override
            public void addPages() {
                this.addPage((IWizardPage)new TheTestWizardPage("PAGE1"));
            }
        };
        this.dialog = new TheTestWizardDialog(null, (IWizard)this.wizard);
        this.dialog.create();
        this.dialog.open();
        Composite parent = this.dialog.getFinishedButton().getParent();
        Control[] children = parent.getChildren();
        Assert.assertEquals((String)"There should be two children, the finish button, and the cancel button", (long)2L, (long)children.length);
        int finishIndex = parent.getDisplay().getDismissalAlignment() == 16384 ? 0 : 1;
        int cancelIndex = parent.getDisplay().getDismissalAlignment() == 16384 ? 1 : 0;
        Assert.assertEquals((String)"Finish button's alignment is off", (Object)this.dialog.getFinishedButton(), (Object)children[finishIndex]);
        Assert.assertEquals((String)"Cancel button's alignment is off", (Object)this.dialog.getCancelButton(), (Object)children[cancelIndex]);
    }

    @Test
    public void testBug270174() {
        this.wizard = new TheTestWizard(){

            public boolean canFinish() {
                return false;
            }
        };
        this.dialog = new TheTestWizardDialog(null, (IWizard)this.wizard);
        this.dialog.create();
        this.dialog.open();
        Composite parent = this.dialog.getFinishedButton().getParent();
        Control[] children = parent.getChildren();
        Assert.assertEquals((String)"There should be three children, a composite for back/next buttons, the finish button, and the cancel button", (long)3L, (long)children.length);
        Assert.assertTrue((boolean)(children[0] instanceof Composite));
        Composite backNextParent = (Composite)children[0];
        Control[] backNextChildren = backNextParent.getChildren();
        Assert.assertEquals((String)"Back button should be the first button", (Object)this.dialog.getBackButton(), (Object)backNextChildren[0]);
        Assert.assertEquals((String)"Next button should be the second button", (Object)this.dialog.getNextButton(), (Object)backNextChildren[1]);
        int finishIndex = parent.getDisplay().getDismissalAlignment() == 16384 ? 1 : 2;
        int cancelIndex = parent.getDisplay().getDismissalAlignment() == 16384 ? 2 : 1;
        Assert.assertEquals((String)"Finish button's alignment is off", (Object)this.dialog.getFinishedButton(), (Object)children[finishIndex]);
        Assert.assertEquals((String)"Cancel button's alignment is off", (Object)this.dialog.getCancelButton(), (Object)children[cancelIndex]);
    }
}

