/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.wizards;

import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.tests.wizards.TheTestWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WizardProgressMonitorTest {
    private ProgressMonitoringWizardDialog dialog;

    @Before
    public void setUp() throws Exception {
        Display.getDefault();
        this.dialog = new ProgressMonitoringWizardDialog((IWizard)new TheTestWizard());
        this.dialog.setBlockOnOpen(false);
    }

    @After
    public void tearDown() throws Exception {
        if (this.dialog != null) {
            this.dialog.close();
        }
        this.dialog = null;
    }

    @Test
    public void testProgressLabelsClearedBug271530() throws Exception {
        String[] taskNames = new String[]{"Task A", "Task B"};
        this.dialog.useStopButton = true;
        this.dialog.open();
        this.dialog.run(false, true, this.getRunnable(taskNames[0]));
        this.performAsserts();
        this.dialog.run(false, true, this.getRunnable(taskNames[1]));
        this.performAsserts();
    }

    protected void performAsserts() {
        Assert.assertEquals((String)"The progress monitor's label should have been cleared", (Object)"", (Object)this.dialog.getProgressMonitorLabelText());
        String subTask = this.dialog.getProgressMonitorSubTaskText();
        if (subTask != null && !subTask.isEmpty()) {
            Assert.fail((String)"The progress monitor's subtask should have been cleared");
        }
    }

    protected IRunnableWithProgress getRunnable(String taskName) {
        return monitor -> {
            Assert.assertEquals((String)"The progress monitor's label is not initially empty", (Object)"", (Object)this.dialog.getProgressMonitorLabelText());
            String subTask = this.dialog.getProgressMonitorSubTaskText();
            if (subTask != null && !subTask.isEmpty()) {
                Assert.fail((String)"The progress monitor's subtask is not initially empty");
            }
            monitor.beginTask(taskName, 1);
            monitor.subTask("some sub task");
        };
    }

    @Test
    public void testProgressMonitorWithoutStopButtonBug287887() throws Exception {
        String[] taskNames = new String[]{"Task A", "Task B"};
        this.dialog.useStopButton = false;
        this.dialog.open();
        this.dialog.run(false, true, this.getRunnable(taskNames[0]));
        this.performAsserts();
        this.dialog.run(false, true, this.getRunnable(taskNames[1]));
        this.performAsserts();
    }

    class ProgressMonitorPartSubclass
    extends ProgressMonitorPart {
        ProgressMonitorPartSubclass(Composite parent, Layout layout, boolean useStopButton) {
            super(parent, layout, useStopButton);
        }

        public String getLabelText() {
            return this.fLabel.getText();
        }

        public String getSubTaskText() {
            return this.fSubTaskName;
        }
    }

    class ProgressMonitoringWizardDialog
    extends WizardDialog {
        boolean useStopButton;

        ProgressMonitoringWizardDialog(IWizard newWizard) {
            super(null, newWizard);
        }

        protected ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout pmlayout) {
            return new ProgressMonitorPartSubclass(composite, (Layout)pmlayout, this.useStopButton);
        }

        public String getProgressMonitorLabelText() {
            ProgressMonitorPartSubclass monitor = (ProgressMonitorPartSubclass)this.getProgressMonitor();
            return monitor.getLabelText();
        }

        public String getProgressMonitorSubTaskText() {
            ProgressMonitorPartSubclass monitor = (ProgressMonitorPartSubclass)this.getProgressMonitor();
            return monitor.getSubTaskText();
        }
    }
}

