/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.wizards;

import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.tests.wizards.TheTestWizard;
import org.eclipse.jface.tests.wizards.TheTestWizardDialog;
import org.eclipse.jface.util.ILogger;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WizardTest {
    protected static final int NUM_PAGES = 3;
    static boolean DID_FINISH = false;
    protected static final String WIZARD_TITLE = "TEST WIZARD TITLE";
    protected static final String PAGE_TITLE = "TEST PAGE TITLE";
    protected RGB color1;
    protected RGB color2;
    protected TheTestWizard wizard;
    protected TheTestWizardDialog dialog;
    boolean pageChanged = false;
    boolean pageChangingFired = false;

    @Test
    public void testEndingWithFinish() {
        Assert.assertEquals((String)"Wizard has wrong number of pages", (long)3L, (long)this.wizard.getPageCount());
        Assert.assertEquals((String)"WizardPage.getName() returned wrong name", (Object)"PAGE1", (Object)this.wizard.page1.getName());
        Assert.assertSame((String)"Wizard.getPage() returned wrong page", (Object)this.wizard.getPage("PAGE1"), (Object)((Object)this.wizard.page1));
        this.wizard.setWindowTitle(WIZARD_TITLE);
        Assert.assertEquals((String)"Wizard has wrong title", (Object)this.wizard.getWindowTitle(), (Object)WIZARD_TITLE);
        this.wizard.page1.setTitle(PAGE_TITLE);
        Assert.assertEquals((String)"Wizard has wrong title", (Object)this.wizard.page1.getTitle(), (Object)PAGE_TITLE);
        this.wizard.setTitleBarColor(this.color1);
        Assert.assertEquals((String)"Wizard has wrong title color", (Object)this.wizard.getTitleBarColor(), (Object)this.color1);
        this.wizard.setTitleBarColor(this.color2);
        Assert.assertEquals((String)"Wizard has wrong title color", (Object)this.wizard.getTitleBarColor(), (Object)this.color2);
        Assert.assertSame((String)"Wizard has wrong starting page", (Object)((Object)this.wizard.page1), (Object)this.wizard.getStartingPage());
        Assert.assertSame((String)"Wizard not on starting page", (Object)((Object)this.wizard.page1), (Object)this.dialog.getCurrentPage());
        Assert.assertSame((String)"WizardPage error message should be null", null, (Object)this.wizard.page1.getErrorMessage());
        this.wizard.page1.textInputField.setText("BAD VALUE");
        Assert.assertEquals((String)"WizardPage error message set correctly", (Object)"A bad value was entered", (Object)this.wizard.page1.getErrorMessage());
        this.wizard.page1.textInputField.setText("GOOD VALUE");
        Assert.assertTrue((String)"Page should be completed", (boolean)this.wizard.page1.canFlipToNextPage());
        Assert.assertSame((String)"WizardPage error message should be null", null, (Object)this.wizard.page1.getErrorMessage());
        Assert.assertSame((String)"WizardPage.getNexPage() wrong page", (Object)((Object)this.wizard.page2), (Object)this.wizard.page1.getNextPage());
        Assert.assertSame((String)"Wizard.getNexPage() wrong page", (Object)((Object)this.wizard.page2), (Object)this.wizard.getNextPage((IWizardPage)this.wizard.page1));
        Assert.assertSame((String)"WizardPage.getPreviousPage() wrong page", (Object)((Object)this.wizard.page1), (Object)this.wizard.page2.getPreviousPage());
        Assert.assertSame((String)"Wizard.getPreviousPage() wrong page", (Object)((Object)this.wizard.page1), (Object)this.wizard.getPreviousPage((IWizardPage)this.wizard.page2));
        Assert.assertSame((String)"WizardPage.getNexPage() wrong page", (Object)((Object)this.wizard.page3), (Object)this.wizard.page2.getNextPage());
        Assert.assertSame((String)"Wizard.getPreviousPage() wrong page", (Object)((Object)this.wizard.page2), (Object)this.wizard.getPreviousPage((IWizardPage)this.wizard.page3));
        this.wizard.page2.textInputField.setText("BAD VALUE");
        Assert.assertFalse((String)"Wizard should not be able to finish", (boolean)this.wizard.canFinish());
        this.wizard.page2.textInputField.setText("GOOD VALUE");
        Assert.assertTrue((String)"Wizard should be able to finish", (boolean)this.wizard.canFinish());
        this.dialog.finishPressed();
        Assert.assertTrue((String)"Wizard didn't perform finish", (boolean)DID_FINISH);
    }

    @Test
    public void testEndingWithCancel() {
        Assert.assertSame((String)"Wizard not on starting page", (Object)((Object)this.wizard.page1), (Object)this.dialog.getCurrentPage());
        this.wizard.performCancel();
        Assert.assertFalse((String)"Wizard finished but should not have", (boolean)DID_FINISH);
        this.dialog.cancelPressed();
        Assert.assertFalse((String)"Wizard performed finished but should not have", (boolean)DID_FINISH);
    }

    @Test
    public void testPageChanging() {
        Assert.assertSame((String)"Wizard started on wrong page", (Object)((Object)this.wizard.page1), (Object)this.dialog.getCurrentPage());
        Assert.assertFalse((String)"Back button should be disabled on first page", (boolean)this.dialog.getBackButton().getEnabled());
        Assert.assertTrue((String)"Next button should be enabled on first page", (boolean)this.dialog.getNextButton().getEnabled());
        this.dialog.nextPressed();
        Assert.assertSame((String)"Wizard.nextPressed() set wrong page", (Object)((Object)this.wizard.page2), (Object)this.dialog.getCurrentPage());
        Assert.assertTrue((String)"Back button should be enabled on middle page", (boolean)this.dialog.getBackButton().getEnabled());
        Assert.assertTrue((String)"Next button should be enabled on middle page", (boolean)this.dialog.getNextButton().getEnabled());
        this.wizard.page2.textInputField.setText("BAD VALUE");
        Assert.assertFalse((String)"Finish should be disabled when bad field value", (boolean)this.dialog.getFinishedButton().getEnabled());
        Assert.assertTrue((String)"Cancel should always be enabled", (boolean)this.dialog.getCancelButton().getEnabled());
        this.wizard.page2.textInputField.setText("GOOD VALUE");
        Assert.assertTrue((String)"Finish should be enabled when good field value", (boolean)this.dialog.getFinishedButton().getEnabled());
        this.dialog.nextPressed();
        Assert.assertSame((String)"Wizard.nextPressed() set wrong page", (Object)((Object)this.wizard.page3), (Object)this.dialog.getCurrentPage());
        Assert.assertTrue((String)"Back button should be enabled on last page", (boolean)this.dialog.getBackButton().getEnabled());
        Assert.assertFalse((String)"Next button should be disenabled on last page", (boolean)this.dialog.getNextButton().getEnabled());
        this.dialog.backPressed();
        Assert.assertSame((String)"Wizard.backPressed() set wrong page", (Object)((Object)this.wizard.page2), (Object)this.dialog.getCurrentPage());
        Assert.assertTrue((String)"Back button should be enabled on middle page", (boolean)this.dialog.getBackButton().getEnabled());
        Assert.assertTrue((String)"Next button should be enabled on middle page", (boolean)this.dialog.getNextButton().getEnabled());
        this.dialog.backPressed();
        Assert.assertSame((String)"Wizard.backPressed() set wrong page", (Object)((Object)this.wizard.page1), (Object)this.dialog.getCurrentPage());
        Assert.assertFalse((String)"Back button should be disabled on first page", (boolean)this.dialog.getBackButton().getEnabled());
        Assert.assertTrue((String)"Next button should be enabled on first page", (boolean)this.dialog.getNextButton().getEnabled());
        this.dialog.buttonPressed(15);
        Assert.assertSame((String)"Wizard.backPressed() set wrong page", (Object)((Object)this.wizard.page2), (Object)this.dialog.getCurrentPage());
        this.dialog.buttonPressed(14);
        Assert.assertSame((String)"Wizard.backPressed() set wrong page", (Object)((Object)this.wizard.page1), (Object)this.dialog.getCurrentPage());
    }

    @Test
    public void testShowPage() {
        this.dialog.nextPressed();
        this.dialog.nextPressed();
        Assert.assertSame((String)"Wizard.nextPressed() set wrong page", (Object)((Object)this.wizard.page3), (Object)this.dialog.getCurrentPage());
        this.dialog.showPage((IWizardPage)this.wizard.page1);
        Assert.assertSame((String)"Wizard.showPage() set wrong page", (Object)((Object)this.wizard.page1), (Object)this.dialog.getCurrentPage());
        Assert.assertTrue((String)"Next button should be enabled on first page", (boolean)this.dialog.getNextButton().getEnabled());
    }

    @Test
    public void testPageChangeListening() {
        this.pageChanged = false;
        this.pageChangingFired = false;
        IPageChangedListener changedListener = event -> {
            boolean bl = this.pageChanged = true;
        };
        IPageChangingListener changingListener = event -> {
            Assert.assertFalse((String)"Page should not have changed yet", (boolean)this.pageChanged);
            this.pageChangingFired = true;
        };
        this.dialog.addPageChangedListener(changedListener);
        this.dialog.addPageChangingListener(changingListener);
        Assert.assertFalse((String)"Page change notified unintentially", (boolean)this.pageChanged);
        this.dialog.nextPressed();
        Assert.assertTrue((String)"Wasn't notified of page change", (boolean)this.pageChanged);
        Assert.assertTrue((String)"Wasn't notified of page changing", (boolean)this.pageChangingFired);
        this.dialog.removePageChangingListener(changingListener);
        this.dialog.nextPressed();
        this.pageChanged = false;
        this.dialog.removePageChangedListener(changedListener);
        this.dialog.nextPressed();
        Assert.assertFalse((String)"Page change notified unintentially", (boolean)this.pageChanged);
    }

    @Test
    public void testWizardDispose() {
        Shell shell;
        this.wizard.setThrowExceptionOnDispose(true);
        boolean[] logged = new boolean[1];
        ILogger oldLogger = Policy.getLog();
        try {
            Policy.setLog(status -> {
                boolean bl = blArray[0] = true;
            });
            shell = this.dialog.getShell();
            this.dialog.close();
        }
        finally {
            Policy.setLog((ILogger)oldLogger);
        }
        Assert.assertTrue((boolean)logged[0]);
        shell.dispose();
    }

    @Test
    public void testWizardPageDispose() {
        this.wizard.page2.setThrowExceptionOnDispose(true);
        boolean[] logged = new boolean[1];
        ILogger oldLogger = Policy.getLog();
        try {
            Policy.setLog(status -> {
                boolean bl = blArray[0] = true;
            });
            this.dialog.close();
        }
        finally {
            Policy.setLog((ILogger)oldLogger);
        }
        Assert.assertTrue((boolean)logged[0]);
        Assert.assertTrue((boolean)this.wizard.page1.getControl().isDisposed());
        Assert.assertTrue((boolean)this.wizard.page3.getControl().isDisposed());
    }

    @Before
    public void setUp() throws Exception {
        DID_FINISH = false;
        this.color1 = new RGB(255, 0, 0);
        this.color2 = new RGB(0, 255, 0);
        this.createWizardDialog();
    }

    @After
    public void tearDown() throws Exception {
        if (this.dialog.getShell() != null && !this.dialog.getShell().isDisposed()) {
            this.dialog.close();
        }
    }

    protected void createWizardDialog() {
        Display.getDefault();
        this.wizard = new TheTestWizard();
        this.dialog = new TheTestWizardDialog(null, (IWizard)this.wizard);
        this.dialog.create();
        this.dialog.open();
    }
}

