/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextEditor;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class AbstratGenericEditorTest {
    protected IProject project;
    protected IFile file;
    protected ExtensionBasedTextEditor editor;
    protected IWorkbenchWindow window;

    @BeforeEach
    public void setUp() throws Exception {
        AbstratGenericEditorTest.closeIntro();
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClass().getName() + System.currentTimeMillis());
        this.project.create(null);
        this.project.open(null);
        this.project.setDefaultCharset(StandardCharsets.UTF_8.name(), null);
        UITestUtil.waitForJobs((long)100L, (long)5000L);
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        UITestUtil.forceActive((Shell)this.window.getShell());
        this.createAndOpenFile();
    }

    protected void createAndOpenFile() throws Exception {
        this.createAndOpenFile("foo.txt", "bar 'bar'");
    }

    protected void createAndOpenFile(String name, String contents) throws Exception {
        this.createAndOpenFile(name, contents, () -> new FileEditorInput(this.file));
    }

    protected void createAndOpenFile(String name, String contents, Supplier<? extends IEditorInput> inputCreator) throws Exception {
        this.file = this.project.getFile(name);
        this.file.create(contents.getBytes(StandardCharsets.UTF_8), 1, null);
        this.file.setCharset(StandardCharsets.UTF_8.name(), null);
        this.editor = (ExtensionBasedTextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(inputCreator.get(), "org.eclipse.ui.genericeditor.GenericEditor");
        DisplayHelper.runEventLoop((Display)PlatformUI.getWorkbench().getDisplay(), (long)0L);
    }

    protected void cleanFileAndEditor() throws Exception {
        if (this.editor != null) {
            this.editor.close(false);
            this.editor = null;
        }
        DisplayHelper.runEventLoop((Display)PlatformUI.getWorkbench().getDisplay(), (long)0L);
        if (this.file != null) {
            this.file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            this.file = null;
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanFileAndEditor();
        if (this.project != null) {
            this.project.delete(true, null);
        }
    }

    private static void closeIntro() {
        IIntroPart intro = PlatformUI.getWorkbench().getIntroManager().getIntro();
        if (intro != null) {
            PlatformUI.getWorkbench().getIntroManager().closeIntro(intro);
            DisplayHelper.runEventLoop((Display)PlatformUI.getWorkbench().getDisplay(), (long)0L);
        }
    }
}

