/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.genericeditor.tests.contributions.EnabledPropertyTester;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class CompletionTest
extends AbstratGenericEditorTest {
    private Shell completionShell;

    @Test
    @DisabledOnOs(value={OS.MAC}, disabledReason="test fails on Mac, see https://github.com/eclipse-platform/eclipse.platform.ui/issues/906")
    public void testCompletion() throws Exception {
        this.editor.selectAndReveal(3, 0);
        this.completionShell = this.openContentAssist(true);
        Table completionProposalList = CompletionTest.findCompletionSelectionControl((Widget)this.completionShell);
        this.checkCompletionContent(completionProposalList);
    }

    @Test
    public void testDefaultContentAssistBug570488() throws Exception {
        ILog log = ILog.of((Bundle)Platform.getBundle((String)"org.eclipse.jface.text"));
        TestLogListener listener = new TestLogListener();
        log.addLogListener((ILogListener)listener);
        this.createAndOpenFile("Bug570488.txt", "bar 'bar'");
        this.openContentAssist(false);
        DisplayHelper.runEventLoop((Display)Display.getCurrent(), (long)0L);
        Assertions.assertFalse((boolean)listener.messages.stream().anyMatch(s -> s.matches(4)), (String)"There are errors in the log");
        log.removeLogListener((ILogListener)listener);
    }

    @Test
    @DisabledOnOs(value={OS.MAC}, disabledReason="test fails on Mac, see https://github.com/eclipse-platform/eclipse.platform.ui/issues/906")
    public void testCompletionService() throws Exception {
        Bundle bundle = FrameworkUtil.getBundle(CompletionTest.class);
        Assertions.assertNotNull((Object)bundle);
        BundleContext bundleContext = bundle.getBundleContext();
        Assertions.assertNotNull((Object)bundleContext);
        MockContentAssistProcessor service = new MockContentAssistProcessor();
        ServiceRegistration registration = bundleContext.registerService(IContentAssistProcessor.class, (Object)service, new Hashtable<String, String>(Collections.singletonMap("contentType", "org.eclipse.ui.genericeditor.tests.content-type")));
        DisplayHelper.runEventLoop((Display)Display.getCurrent(), (long)0L);
        this.editor.selectAndReveal(3, 0);
        this.completionShell = this.openContentAssist(true);
        Table completionProposalList = CompletionTest.findCompletionSelectionControl((Widget)this.completionShell);
        Assertions.assertTrue((boolean)service.called, (String)"Service was not called!");
        this.checkCompletionContent(completionProposalList);
        registration.unregister();
    }

    @Test
    @DisabledOnOs(value={OS.MAC}, disabledReason="test fails on Mac, see https://github.com/eclipse-platform/eclipse.platform.ui/issues/906")
    public void testCompletionUsingViewerSelection() throws Exception {
        this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set("abc");
        this.editor.selectAndReveal(0, 3);
        this.completionShell = this.openContentAssist(true);
        Table completionProposalList = CompletionTest.findCompletionSelectionControl((Widget)this.completionShell);
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)completionProposalList.getDisplay(), (long)5000L, () -> {
            Assertions.assertFalse((boolean)completionProposalList.isDisposed(), (String)"Completion proposal list was unexpectedly disposed");
            return Arrays.stream(completionProposalList.getItems()).map(TableItem::getText).anyMatch("ABC"::equals);
        }), (String)"Proposal list did not contain expected item: ABC");
    }

    @Test
    public void testEnabledWhenCompletion() throws Exception {
        EnabledPropertyTester.setEnabled(false);
        this.createAndOpenFile("enabledWhen.txt", "bar 'bar'");
        this.editor.selectAndReveal(3, 0);
        Assertions.assertNull((Object)this.openContentAssist(false), (String)"A new shell was found");
        this.cleanFileAndEditor();
        EnabledPropertyTester.setEnabled(true);
        this.createAndOpenFile("enabledWhen.txt", "bar 'bar'");
        this.editor.selectAndReveal(3, 0);
        Assertions.assertNotNull((Object)this.openContentAssist(true));
    }

    private Shell openContentAssist(boolean expectShell) {
        ContentAssistAction action = (ContentAssistAction)this.editor.getAction("ContentAssistProposal");
        action.update();
        Set<Shell> beforeShells = Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        action.run();
        Shell shell = CompletionTest.findNewShell(beforeShells, this.editor.getSite().getShell().getDisplay(), expectShell);
        DisplayHelper.runEventLoop((Display)PlatformUI.getWorkbench().getDisplay(), (long)100L);
        return shell;
    }

    private void checkCompletionContent(Table completionProposalList) {
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)completionProposalList.getDisplay(), (long)200L, () -> {
            Assertions.assertFalse((boolean)completionProposalList.isDisposed(), (String)"Completion proposal list was unexpectedly disposed");
            return completionProposalList.getItemCount() == 2 && completionProposalList.getItem(1).getData() != null;
        }), (String)"Proposal list did not show two initial items");
        Assertions.assertTrue((boolean)CompletionTest.isComputingInfoEntry(completionProposalList.getItem(0)), (String)"Missing computing info entry in proposal list");
        TableItem initialProposalItem = completionProposalList.getItem(1);
        System.out.println(initialProposalItem.toString());
        String initialProposalString = ((ICompletionProposal)initialProposalItem.getData()).getDisplayString();
        MatcherAssert.assertThat((String)"Unexpected initial proposal item", (Object)"bars are good for a beer.", (Matcher)CoreMatchers.endsWith((String)initialProposalString));
        completionProposalList.setSelection(initialProposalItem);
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)completionProposalList.getDisplay(), (long)4000L, () -> {
            Assertions.assertFalse((boolean)completionProposalList.isDisposed(), (String)"Completion proposal list was unexpectedly disposed");
            return !CompletionTest.isComputingInfoEntry(completionProposalList.getItem(0)) && completionProposalList.getItemCount() == 2;
        }), (String)"Proposal list did not show two items after finishing computing");
        TableItem firstCompletionProposalItem = completionProposalList.getItem(0);
        TableItem secondCompletionProposalItem = completionProposalList.getItem(1);
        String firstCompletionProposalText = ((ICompletionProposal)firstCompletionProposalItem.getData()).getDisplayString();
        String secondCompletionProposalText = ((ICompletionProposal)secondCompletionProposalItem.getData()).getDisplayString();
        MatcherAssert.assertThat((String)"Unexpected first proposal item", (Object)"bars are good for a beer.", (Matcher)CoreMatchers.endsWith((String)firstCompletionProposalText));
        MatcherAssert.assertThat((String)"Unexpected second proposal item", (Object)"bars are also good for soft drink cocktails.", (Matcher)CoreMatchers.endsWith((String)secondCompletionProposalText));
        String selectedProposalString = ((ICompletionProposal)completionProposalList.getSelection()[0].getData()).getDisplayString();
        Assertions.assertEquals((Object)initialProposalString, (Object)selectedProposalString, (String)"Addition of completion proposal should keep selection");
    }

    private static boolean isComputingInfoEntry(TableItem item) {
        return item.getText().contains("Computing");
    }

    public static Shell findNewShell(Set<Shell> beforeShells, Display display, boolean expectShell) {
        List<Shell> afterShells = Arrays.stream(display.getShells()).filter(Shell::isVisible).filter(shell -> !beforeShells.contains(shell)).toList();
        if (expectShell) {
            Assertions.assertEquals((int)1, (int)afterShells.size(), (String)"No new shell found");
        }
        return afterShells.isEmpty() ? null : afterShells.get(0);
    }

    @Test
    @DisabledOnOs(value={OS.MAC}, disabledReason="test fails on Mac, see https://github.com/eclipse-platform/eclipse.platform.ui/issues/906")
    public void testCompletionFreeze_bug521484() throws Exception {
        this.editor.selectAndReveal(3, 0);
        this.completionShell = this.openContentAssist(true);
        Table completionProposalList = CompletionTest.findCompletionSelectionControl((Widget)this.completionShell);
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)completionProposalList.getDisplay(), (long)200L, () -> {
            Assertions.assertFalse((boolean)completionProposalList.isDisposed(), (String)"Completion proposal list was unexpectedly disposed");
            return completionProposalList.getItemCount() == 2;
        }), (String)"Proposal list did not show two items");
        Assertions.assertTrue((boolean)CompletionTest.isComputingInfoEntry(completionProposalList.getItem(0)), (String)"Missing computing info entry");
        long timestamp = System.currentTimeMillis();
        this.emulatePressLeftArrowKey();
        DisplayHelper.sleep((Display)this.editor.getSite().getShell().getDisplay(), (long)200L);
        long processingDuration = System.currentTimeMillis() - timestamp;
        Assertions.assertTrue((processingDuration < 2000L ? 1 : 0) != 0, (String)("UI Thread frozen for " + processingDuration + "ms"));
    }

    @Test
    @DisabledOnOs(value={OS.MAC}, disabledReason="test fails on Mac, see https://github.com/eclipse-platform/eclipse.platform.ui/issues/906")
    public void testMoveCaretBackUsesAllProcessors_bug522255() throws Exception {
        this.testCompletion();
        this.emulatePressLeftArrowKey();
        Set<Shell> beforeShells = Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        DisplayHelper.sleep((Display)this.editor.getSite().getShell().getDisplay(), (long)200L);
        this.completionShell = CompletionTest.findNewShell(beforeShells, this.editor.getSite().getShell().getDisplay(), true);
        Table completionProposalList = CompletionTest.findCompletionSelectionControl((Widget)this.completionShell);
        this.checkCompletionContent(completionProposalList);
    }

    private void emulatePressLeftArrowKey() {
        this.editor.selectAndReveal(((ITextSelection)this.editor.getSelectionProvider().getSelection()).getOffset() - 1, 0);
        Control styledText = (Control)this.editor.getAdapter(Control.class);
        Event e = new Event();
        e.type = 3005;
        e.widget = styledText;
        e.keyCode = 0x1000003;
        e.display = styledText.getDisplay();
        styledText.notifyListeners(3005, e);
    }

    public static Table findCompletionSelectionControl(Widget control) {
        LinkedList<Object> widgetsToProcess = new LinkedList<Object>();
        widgetsToProcess.add(control);
        while (!widgetsToProcess.isEmpty()) {
            Widget child = (Widget)widgetsToProcess.poll();
            if (child instanceof Table) {
                Table table = (Table)child;
                return table;
            }
            if (!(child instanceof Composite)) continue;
            Composite composite = (Composite)child;
            widgetsToProcess.addAll(Arrays.asList(composite.getChildren()));
        }
        Assertions.fail((String)("No completion selection control found in widget: " + String.valueOf(control)));
        return null;
    }

    @AfterEach
    public void closeShell() {
        if (this.completionShell != null && !this.completionShell.isDisposed()) {
            this.completionShell.close();
        }
    }

    private static final class MockContentAssistProcessor
    implements IContentAssistProcessor {
        private boolean called;

        private MockContentAssistProcessor() {
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            this.called = true;
            return null;
        }

        public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
            return null;
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            return null;
        }

        public char[] getContextInformationAutoActivationCharacters() {
            return null;
        }

        public String getErrorMessage() {
            return null;
        }

        public IContextInformationValidator getContextInformationValidator() {
            return null;
        }
    }

    private static final class TestLogListener
    implements ILogListener {
        List<IStatus> messages = new ArrayList<IStatus>();

        private TestLogListener() {
        }

        public void logging(IStatus status, String plugin) {
            this.messages.add(status);
        }
    }
}

