/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.tests.Accessor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContextInfoTest
extends AbstratGenericEditorTest {
    private Shell completionShell;

    @Test
    public void testContextInfo() throws Exception {
        this.cleanFileAndEditor();
        this.createAndOpenFile("foobar.txt", "bars are good for a beer.");
        Set<Shell> beforeShells = Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        TextOperationAction action = (TextOperationAction)this.editor.getAction("ContentAssistContextInformation");
        this.editor.selectAndReveal(4, 0);
        DisplayHelper.runEventLoop((Display)PlatformUI.getWorkbench().getDisplay(), (long)0L);
        action.update();
        action.run();
        this.completionShell = this.findNewShell(beforeShells);
        Assertions.assertEquals((Object)this.getInfoText(this.completionShell), (Object)"idx= 0");
        this.editor.selectAndReveal(8, 0);
        DisplayHelper.runEventLoop((Display)PlatformUI.getWorkbench().getDisplay(), (long)0L);
        action.update();
        action.run();
        this.completionShell = this.findNewShell(beforeShells);
        Assertions.assertEquals((Object)this.getInfoText(this.completionShell), (Object)"idx= 1");
    }

    @Test
    public void testContextInfo_hide_Bug512251() throws Exception {
        this.cleanFileAndEditor();
        this.createAndOpenFile("foobar.txt", "bars are good for a beer.");
        Set<Shell> beforeShells = Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        TextOperationAction action = (TextOperationAction)this.editor.getAction("ContentAssistContextInformation");
        this.editor.selectAndReveal(4, 0);
        DisplayHelper.runEventLoop((Display)PlatformUI.getWorkbench().getDisplay(), (long)0L);
        action.update();
        action.run();
        this.completionShell = this.findNewShell(beforeShells);
        this.editor.selectAndReveal(8, 0);
        DisplayHelper.runEventLoop((Display)PlatformUI.getWorkbench().getDisplay(), (long)0L);
        action.update();
        action.run();
        this.completionShell = this.findNewShell(beforeShells);
        this.editor.getAction("DeleteLine").run();
        ITextViewer sourceViewer = (ITextViewer)this.editor.getAdapter(ITextViewer.class);
        ContentAssistant assist = (ContentAssistant)new Accessor((Object)sourceViewer, SourceViewer.class).get("fContentAssistant");
        new Accessor((Object)assist, ContentAssistant.class).invoke("hide", new Object[0]);
    }

    private Shell findNewShell(Set<Shell> beforeShells) {
        DisplayHelper.runEventLoop((Display)PlatformUI.getWorkbench().getDisplay(), (long)100L);
        Shell[] afterShells = this.findNewShells(beforeShells);
        if (afterShells.length == 0) {
            DisplayHelper.runEventLoop((Display)PlatformUI.getWorkbench().getDisplay(), (long)1000L);
        }
        afterShells = this.findNewShells(beforeShells);
        Assertions.assertEquals((int)1, (int)afterShells.length, (String)"No new shell found");
        return afterShells[0];
    }

    private Shell[] findNewShells(Set<Shell> beforeShells) {
        Shell[] afterShells = (Shell[])Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).filter(shell -> !beforeShells.contains(shell)).toArray(Shell[]::new);
        return afterShells;
    }

    private String getInfoText(Shell shell) {
        Control[] children;
        Assertions.assertTrue((boolean)shell.isVisible());
        Control[] controlArray = children = shell.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Text) {
                Text text = (Text)child;
                return text.getText();
            }
            if (child instanceof StyledText) {
                StyledText styled = (StyledText)child;
                return styled.getText();
            }
            ++n2;
        }
        return null;
    }

    @AfterEach
    public void closeShell() {
        if (this.completionShell != null && !this.completionShell.isDisposed()) {
            this.completionShell.close();
        }
    }
}

