/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.genericeditor.tests.contributions.EnabledPropertyTester;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DoubleClickTest
extends AbstratGenericEditorTest {
    private static final String EDITOR_TEXT = "one two three\nfour five six\nseven eight nine";

    @Override
    protected void createAndOpenFile() throws Exception {
        this.createAndOpenFile("foo.txt", EDITOR_TEXT);
    }

    @Test
    public void testDefaultDoubleClick() throws Exception {
        this.checkDoubleClickSelectionForCaretOffset(EDITOR_TEXT.indexOf("five") + 1, "five");
    }

    @Test
    public void testEnabledWhenDoubleClick() throws Exception {
        EnabledPropertyTester.setEnabled(true);
        this.createAndOpenFile("enabledWhen.txt", EDITOR_TEXT);
        this.checkDoubleClickSelectionForCaretOffset(EDITOR_TEXT.indexOf("five") + 1, "four five six");
        EnabledPropertyTester.setEnabled(false);
    }

    private void checkDoubleClickSelectionForCaretOffset(int pos, String expectedSelection) throws Exception {
        this.editor.selectAndReveal(pos, 0);
        StyledText editorTextWidget = (StyledText)this.editor.getAdapter(Control.class);
        DisplayHelper.runEventLoop((Display)editorTextWidget.getDisplay(), (long)0L);
        DisplayHelper.waitForCondition((Display)editorTextWidget.getDisplay(), (long)3000L, () -> editorTextWidget.isFocusControl() && styledText.getSelection().x == pos);
        editorTextWidget.getShell().forceActive();
        editorTextWidget.getShell().setActive();
        editorTextWidget.getShell().setFocus();
        editorTextWidget.getShell().getDisplay().wake();
        Rectangle target = editorTextWidget.getCaret().getBounds();
        this.doubleClick(editorTextWidget, target.x + 5, target.y + 5);
        Assertions.assertEquals((Object)expectedSelection, (Object)editorTextWidget.getSelectionText());
    }

    private void doubleClick(StyledText widget, int x, int y) {
        widget.getDisplay().setCursorLocation(widget.toDisplay(x, y));
        DisplayHelper.runEventLoop((Display)widget.getDisplay(), (long)0L);
        Event mouseDownEvent = new Event();
        mouseDownEvent.button = 1;
        mouseDownEvent.display = widget.getDisplay();
        mouseDownEvent.doit = true;
        mouseDownEvent.type = 3;
        mouseDownEvent.widget = widget;
        mouseDownEvent.x = x;
        mouseDownEvent.y = y;
        Event mouseUpEvent = new Event();
        mouseUpEvent.button = 1;
        mouseUpEvent.display = widget.getDisplay();
        mouseUpEvent.doit = true;
        mouseUpEvent.type = 4;
        mouseUpEvent.widget = widget;
        mouseUpEvent.x = x;
        mouseUpEvent.y = y;
        this.postEvent(widget, mouseDownEvent);
        this.postEvent(widget, mouseUpEvent);
        this.postEvent(widget, mouseDownEvent);
        this.postEvent(widget, mouseUpEvent);
    }

    private void postEvent(StyledText widget, Event event) {
        Listener[] listeners;
        event.time = (int)System.currentTimeMillis();
        Listener[] listenerArray = listeners = widget.getListeners(event.type);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
        DisplayHelper.runEventLoop((Display)widget.getDisplay(), (long)0L);
    }
}

