/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import org.eclipse.core.commands.Command;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.handlers.IHandlerService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EditorTest
extends AbstratGenericEditorTest {
    @Test
    public void testGenericEditorHasWordWrap() throws Exception {
        this.editor.setFocus();
        StyledText editorTextWidget = (StyledText)this.editor.getAdapter(Control.class);
        Assertions.assertFalse((boolean)editorTextWidget.getWordWrap());
        Assertions.assertFalse((boolean)this.editor.isWordWrapEnabled());
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command wordWrapCommand = commandService.getCommand("org.eclipse.ui.edit.text.toggleWordWrap");
        Assertions.assertTrue((boolean)wordWrapCommand.isDefined());
        Assertions.assertTrue((boolean)wordWrapCommand.isEnabled());
        Assertions.assertTrue((boolean)wordWrapCommand.isHandled());
        ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(wordWrapCommand.getId(), null);
        Assertions.assertTrue((boolean)editorTextWidget.getWordWrap());
        Assertions.assertTrue((boolean)this.editor.isWordWrapEnabled());
    }

    @Test
    public void testGenericEditorCanShowWhitespaceCharacters() throws Exception {
        this.editor.setFocus();
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command wordWrapCommand = commandService.getCommand("org.eclipse.ui.edit.text.toggleShowWhitespaceCharacters");
        Assertions.assertTrue((boolean)wordWrapCommand.isDefined());
        Assertions.assertTrue((boolean)wordWrapCommand.isEnabled());
        Assertions.assertTrue((boolean)wordWrapCommand.isHandled());
        ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(wordWrapCommand.getId(), null);
    }

    @Test
    public void testGenericEditorCanUseBlockSelection() throws Exception {
        this.editor.setFocus();
        Assertions.assertFalse((boolean)this.editor.isBlockSelectionModeEnabled());
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command wordWrapCommand = commandService.getCommand("org.eclipse.ui.edit.text.toggleBlockSelectionMode");
        Assertions.assertTrue((boolean)wordWrapCommand.isDefined());
        Assertions.assertTrue((boolean)wordWrapCommand.isEnabled());
        Assertions.assertTrue((boolean)wordWrapCommand.isHandled());
        ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(wordWrapCommand.getId(), null);
        Assertions.assertTrue((boolean)this.editor.isBlockSelectionModeEnabled());
    }
}

