/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.genericeditor.tests.contributions.EnabledPropertyTester;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FoldingTest
extends AbstratGenericEditorTest {
    @Override
    protected void createAndOpenFile() throws Exception {
    }

    @Test
    public void testDefaultIndentFoldingOneFold() throws Exception {
        this.createAndOpenFile("bar.xml", "<a>\n b</a>");
        this.assertFoldingAsync(FoldingTest.pos(0, 10));
    }

    @Test
    public void testDefaultIndentFoldingTwoFold() throws Exception {
        this.createAndOpenFile("bar.xml", "<a>\n <b>\n  c\n </b>\n</a>");
        this.assertFoldingAsync(FoldingTest.pos(0, 19), FoldingTest.pos(4, 9));
    }

    @Test
    public void testCustomFoldingReconciler() throws Exception {
        this.createAndOpenFile("bar.txt", "<a>\n <b>\n  c\n </b>\n</a>\n");
        this.assertFoldingAsync(FoldingTest.pos(0, 24), FoldingTest.pos(5, 14));
    }

    @Test
    public void testEnabledWhenCustomFoldingReconciler() throws Exception {
        EnabledPropertyTester.setEnabled(true);
        this.createAndOpenFile("enabledWhen.txt", "<a>\n <b>\n  c\n </b>\n</a>\n");
        this.assertFoldingAsync(FoldingTest.pos(0, 24), FoldingTest.pos(5, 14));
        this.cleanFileAndEditor();
        EnabledPropertyTester.setEnabled(false);
        this.createAndOpenFile("enabledWhen.txt", "<a>\n <b>\n  c\n </b>\n</a>\n");
        this.assertFoldingAsync(new Position[0]);
    }

    private static Position pos(int offset, int length) {
        return new Position(offset, length);
    }

    private void assertFoldingAsync(Position ... expectedPositions) {
        DisplayHelper.waitForCondition((Display)this.editor.getSite().getShell().getDisplay(), (long)5000L, () -> {
            Object[] actualPositions = (Position[])this.getAnnotationsFromAnnotationModel().stream().map(arg_0 -> ((IAnnotationModel)this.getProjectionAnnotationModel()).getPosition(arg_0)).filter(Objects::nonNull).sorted(Comparator.comparingInt(Position::getOffset)).toArray(Position[]::new);
            return Arrays.deepEquals(actualPositions, expectedPositions);
        });
    }

    private IAnnotationModel getProjectionAnnotationModel() {
        ProjectionViewer dp = (ProjectionViewer)this.editor.getAdapter(ITextViewer.class);
        ProjectionAnnotationModel am = dp.getProjectionAnnotationModel();
        return am;
    }

    private List<Annotation> getAnnotationsFromAnnotationModel() {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        Iterator annotationIterator = this.getProjectionAnnotationModel().getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Annotation ann = (Annotation)annotationIterator.next();
            if (!ann.getType().equals("org.eclipse.projection")) continue;
            annotationList.add(ann);
        }
        return annotationList;
    }

    @Test
    public void testFoldingCommandsEnabled() throws Exception {
        this.createAndOpenFile("bar.xml", "<a>\n b</a>");
        ICommandService commandService = (ICommandService)this.editor.getEditorSite().getService(ICommandService.class);
        Command collapseAllCommand = commandService.getCommand("org.eclipse.ui.edit.text.folding.collapse_all");
        Assertions.assertTrue((collapseAllCommand.isEnabled() && collapseAllCommand.isHandled() ? 1 : 0) != 0);
    }
}

