/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.genericeditor.tests.contributions.EnabledPropertyTester;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HighlightTest
extends AbstratGenericEditorTest {
    private static final String ANNOTATION_TYPE = "org.eclipse.ui.genericeditor.text";
    private static final String EDITOR_TEXT = "Lorem ipsum dolor sit amet, consectetur adipiscing elit.\nLorem ipsum dolor sit amet, consectetur adipiscing elit.\nLorem ipsum dolor sit amet, consectetur adipiscing elit.";

    @Override
    protected void createAndOpenFile() throws Exception {
    }

    @Test
    public void testCustomHighlightReconciler() throws Exception {
        this.createAndOpenFile("bar.txt", "bar 'bar'");
        this.checkHighlightForCaretOffset(0, "'bar'", 1);
    }

    @Test
    public void testCustomHighlightReconcilerForFileFromHistory() throws Exception {
        this.createAndOpenFile("bar.txt", "bar 'bar'", () -> new FileEditorInput(this.file){

            public String getName() {
                return super.getName() + " 61e418fdac6";
            }

            public <T> T getAdapter(Class<T> adapter) {
                return (T)(adapter == IStorage.class ? this.getStorage() : super.getAdapter(adapter));
            }
        });
        this.checkHighlightForCaretOffset(0, "'bar'", 1);
    }

    @Test
    public void testEnabledWhenCustomHighlightReconciler() throws Exception {
        EnabledPropertyTester.setEnabled(true);
        this.createAndOpenFile("enabledWhen.txt", "bar 'bar'");
        this.checkHighlightForCaretOffset(0, "'bar'", 1);
        this.cleanFileAndEditor();
        EnabledPropertyTester.setEnabled(false);
        this.createAndOpenFile("enabledWhen.txt", "bar 'bar'");
        this.checkHighlightForCaretOffset(0, "'bar'", 0);
    }

    @Test
    public void testHighlightWordAtDocumentStart() throws Exception {
        this.createAndOpenFile("foo.txt", EDITOR_TEXT);
        this.checkHighlightForCaretOffset(0, "Lorem", 3);
    }

    @Test
    public void testHighlightWordWithNonLetterParts() throws Exception {
        String complexWord = "dolor_sit123amet45";
        String editorText = EDITOR_TEXT.replaceFirst("dolor sit amet", complexWord).replaceFirst("dolor sit amet", complexWord);
        this.createAndOpenFile("foo.txt", editorText);
        this.checkHighlightForCaretOffset(editorText.indexOf("dolor") + 3, complexWord, 2);
        this.checkHighlightForCaretOffset(editorText.indexOf("_sit") + 3, complexWord, 2);
        this.checkHighlightForCaretOffset(editorText.indexOf("123") + 1, complexWord, 2);
        this.checkHighlightForCaretOffset(editorText.indexOf("amet") + 1, complexWord, 2);
    }

    @Test
    public void testHighlightSimpleWordNotMatchingWordPart() throws Exception {
        String complexWord = "dolor_sit123amet45";
        String editorText = EDITOR_TEXT.replaceFirst("dolor sit amet", complexWord);
        this.createAndOpenFile("foo.txt", editorText);
        this.checkHighlightForCaretOffset(editorText.indexOf("dolor ") + 1, "dolor", 2);
        this.checkHighlightForCaretOffset(editorText.indexOf(" sit") + 1, "sit", 2);
        this.checkHighlightForCaretOffset(editorText.indexOf(" amet") + 1, "amet", 2);
    }

    @Test
    public void testHighlightNonAsciiCharacters() throws Exception {
        String complexWord = "sit\u00f6\u00f6amet";
        String editorText = EDITOR_TEXT.replaceFirst("sit amet", complexWord).replaceFirst("sit amet", complexWord);
        this.createAndOpenFile("foo.txt", editorText);
        this.checkHighlightForCaretOffset(editorText.indexOf("sit") + 1, complexWord, 2);
        this.checkHighlightForCaretOffset(editorText.indexOf("\u00f6") + 1, complexWord, 2);
        this.checkHighlightForCaretOffset(editorText.indexOf("amet") + 1, complexWord, 2);
    }

    private void checkHighlightForCaretOffset(int pos, String expectedHighlight, int expectedHighlightCount) throws Exception {
        this.clearAnnotations();
        this.editor.selectAndReveal(pos, 0);
        DisplayHelper.waitForCondition((Display)Display.getDefault(), (long)2000L, () -> this.getAnnotationsFromAnnotationModel().size() == expectedHighlightCount);
        List<Annotation> annotations = this.getAnnotationsFromAnnotationModel();
        IAnnotationModel annotationModel = this.getAnnotationModel();
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        int i = 0;
        while (i < annotations.size()) {
            Annotation annotation = annotations.get(i);
            Position position = annotationModel.getPosition(annotation);
            String highlight = document.get(position.offset, position.length);
            Assertions.assertEquals((Object)expectedHighlight, (Object)highlight, (String)("Wrong highlight " + i + " at position " + position.offset));
            ++i;
        }
        Assertions.assertEquals((int)expectedHighlightCount, (int)annotations.size(), (String)"Wrong number of highlights");
    }

    private void clearAnnotations() {
        this.editor.selectAndReveal(0, 0);
        IAnnotationModel annotationModel = this.getAnnotationModel();
        List<Annotation> annotations = this.getAnnotationsFromAnnotationModel();
        for (Annotation annotation : annotations) {
            annotationModel.removeAnnotation(annotation);
        }
    }

    private IAnnotationModel getAnnotationModel() {
        IDocumentProvider dp = this.editor.getDocumentProvider();
        IAnnotationModel am = dp.getAnnotationModel((Object)this.editor.getEditorInput());
        return am;
    }

    private List<Annotation> getAnnotationsFromAnnotationModel() {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        Iterator annotationIterator = this.getAnnotationModel().getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Annotation ann = (Annotation)annotationIterator.next();
            if (ann.getType().indexOf(ANNOTATION_TYPE) <= -1) continue;
            annotationList.add(ann);
        }
        return annotationList;
    }
}

