/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.test.Screenshots;
import org.eclipse.text.tests.Accessor;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.genericeditor.tests.contributions.EnabledPropertyTester;
import org.eclipse.ui.genericeditor.tests.contributions.MarkerResolutionGenerator;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

@EnabledOnOs(value={OS.LINUX}, disabledReason="This test currently always fail on Windows and MacOS (bug 505842), skipping")
public class HoverTest
extends AbstratGenericEditorTest {
    private static final int MAXIMUM_HOVER_RETRY_COUNT = 5;

    @Test
    public void testSingleHover(TestInfo info) throws Exception {
        Shell shell = this.getHoverShell(info, this.triggerCompletionAndRetrieveInformationControlManager(), true);
        Assertions.assertNotNull((Object)this.findControl((Control)shell, StyledText.class, "Alrighty!"));
        Assertions.assertNull((Object)this.findControl((Control)shell, StyledText.class, "Hello!"));
        Assertions.assertNull((Object)this.findControl((Control)shell, StyledText.class, "World!"));
    }

    @Test
    public void testEnabledWhenHover(TestInfo info) throws Exception {
        this.cleanFileAndEditor();
        EnabledPropertyTester.setEnabled(true);
        this.createAndOpenFile("enabledWhen.txt", "bar 'bar'");
        Shell shell = this.getHoverShell(info, this.triggerCompletionAndRetrieveInformationControlManager(), true);
        Assertions.assertNotNull((Object)this.findControl((Control)shell, StyledText.class, "Alrighty!"));
        Assertions.assertNull((Object)this.findControl((Control)shell, StyledText.class, "World!"));
        this.cleanFileAndEditor();
        EnabledPropertyTester.setEnabled(false);
        this.createAndOpenFile("enabledWhen.txt", "bar 'bar'");
        shell = this.getHoverShell(info, this.triggerCompletionAndRetrieveInformationControlManager(), true);
        Assertions.assertNull((Object)this.findControl((Control)shell, StyledText.class, "Alrighty!"));
        Assertions.assertNotNull((Object)this.findControl((Control)shell, StyledText.class, "World!"));
    }

    @Test
    public void testMultipleHover(TestInfo info) throws Exception {
        this.cleanFileAndEditor();
        this.createAndOpenFile("bar.txt", "Hi");
        Shell shell = this.getHoverShell(info, this.triggerCompletionAndRetrieveInformationControlManager(), true);
        Assertions.assertNull((Object)this.findControl((Control)shell, StyledText.class, "Alrighty!"));
        Assertions.assertNotNull((Object)this.findControl((Control)shell, StyledText.class, "World!"));
        Assertions.assertNotNull((Object)this.findControl((Control)shell, StyledText.class, "Hello!"));
    }

    @Test
    public void testProblemHover(TestInfo info) throws Exception {
        String problemMessage = "Huston...";
        IMarker marker = null;
        try {
            marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("lineNumber", 1);
            marker.setAttribute("severity", 2);
            marker.setAttribute("charStart", 0);
            marker.setAttribute("charEnd", 5);
            marker.setAttribute("message", (Object)problemMessage);
            marker.setAttribute(MarkerResolutionGenerator.FIXME, true);
            AbstractInformationControlManager manager = this.triggerCompletionAndRetrieveInformationControlManager();
            Object hoverData = this.getHoverData(manager);
            Assertions.assertTrue((boolean)(hoverData instanceof Map), (String)String.valueOf(hoverData));
            Assertions.assertTrue((boolean)((Map)hoverData).containsValue(Collections.singletonList(marker)));
            Assertions.assertTrue((boolean)((Map)hoverData).containsValue("Alrighty!"));
            Assertions.assertFalse((boolean)((Map)hoverData).containsValue("Hello!"));
            Shell shell = this.getHoverShell(info, manager, true);
            Assertions.assertNotNull((Object)this.findControl((Control)shell, Label.class, marker.getAttribute("message", "NONE")));
            Assertions.assertNotNull((Object)this.findControl((Control)shell, StyledText.class, "Alrighty!"));
            Assertions.assertNull((Object)this.findControl((Control)shell, StyledText.class, "Hello!"));
            Link link = this.findControl((Control)shell, Link.class, MarkerResolutionGenerator.FIXME);
            Assertions.assertNotNull((Object)link);
            Event event = new Event();
            event.widget = link;
            event.display = link.getDisplay();
            event.doit = true;
            event.type = 13;
            link.notifyListeners(13, event);
            IMarker m = marker;
            DisplayHelper.waitForCondition((Display)event.display, (long)1000L, () -> !m.exists());
            Assertions.assertFalse((boolean)marker.exists());
        }
        finally {
            if (marker != null && marker.exists()) {
                marker.delete();
            }
        }
    }

    private Shell getHoverShell(TestInfo info, AbstractInformationControlManager manager, boolean failOnError) {
        AbstractInformationControl[] control = new AbstractInformationControl[1];
        DisplayHelper.waitForCondition((Display)this.editor.getSite().getShell().getDisplay(), (long)5000L, () -> {
            abstractInformationControlArray[0] = (AbstractInformationControl)new Accessor((Object)manager, AbstractInformationControlManager.class).get("fInformationControl");
            return control[0] != null;
        });
        if (control[0] == null) {
            if (failOnError) {
                Screenshots.takeScreenshot(this.getClass(), (String)info.getDisplayName());
                Assertions.fail();
            } else {
                return null;
            }
        }
        Shell shell = control[0].getShell();
        DisplayHelper.waitForCondition((Display)this.editor.getSite().getShell().getDisplay(), (long)2000L, () -> shell.isVisible());
        if (failOnError) {
            Assertions.assertTrue((boolean)shell.isVisible());
        }
        return shell;
    }

    private <T extends Control> T findControl(Control control, Class<T> controlType, String label) {
        if (control.getClass() == controlType) {
            Control res = control;
            if (label == null) {
                return (T)res;
            }
            String controlLabel = null;
            if (control instanceof Label) {
                Label l = (Label)control;
                controlLabel = l.getText();
            } else if (control instanceof Link) {
                Link link = (Link)control;
                controlLabel = link.getText();
            } else if (control instanceof Text) {
                Text text = (Text)control;
                controlLabel = text.getText();
            } else if (control instanceof StyledText) {
                StyledText styled = (StyledText)control;
                controlLabel = styled.getText();
            }
            if (controlLabel != null && controlLabel.contains(label)) {
                return (T)res;
            }
        } else if (control instanceof Composite) {
            Composite comp = (Composite)control;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                T res = this.findControl(child, controlType, label);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
        }
        return null;
    }

    private Object getHoverData(AbstractInformationControlManager manager) {
        Object hoverData = new Accessor((Object)manager, AbstractInformationControlManager.class).get("fInformation");
        return hoverData;
    }

    private AbstractInformationControlManager triggerCompletionAndRetrieveInformationControlManager() {
        boolean foundHoverData = false;
        int attemptNumber = 0;
        ITextViewer viewer = (ITextViewer)this.editor.getAdapter(ITextViewer.class);
        AbstractInformationControlManager textHoverManager = (AbstractInformationControlManager)new Accessor((Object)viewer, TextViewer.class).get("fTextHoverManager");
        while (!foundHoverData && attemptNumber++ < 5) {
            int caretLocation = 2;
            this.editor.setFocus();
            this.editor.selectAndReveal(2, 0);
            StyledText editorTextWidget = (StyledText)this.editor.getAdapter(Control.class);
            DisplayHelper.waitForCondition((Display)editorTextWidget.getDisplay(), (long)3000L, () -> editorTextWidget.isFocusControl() && styledText.getSelection().x == 2);
            Assertions.assertTrue((boolean)editorTextWidget.isFocusControl(), (String)"editor does not have focus");
            Event hoverEvent = new Event();
            hoverEvent.widget = editorTextWidget;
            hoverEvent.type = 32;
            hoverEvent.x = editorTextWidget.getClientArea().x + 5;
            hoverEvent.y = editorTextWidget.getClientArea().y + 5;
            hoverEvent.display = editorTextWidget.getDisplay();
            hoverEvent.doit = true;
            editorTextWidget.getDisplay().setCursorLocation(editorTextWidget.toDisplay(hoverEvent.x, hoverEvent.y));
            editorTextWidget.notifyListeners(32, hoverEvent);
            foundHoverData = DisplayHelper.waitForCondition((Display)hoverEvent.display, (long)6000L, () -> this.getHoverData(textHoverManager) != null);
        }
        Assertions.assertTrue((boolean)foundHoverData, (String)"hover data not found");
        return textHoverManager;
    }
}

