/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.lang.reflect.Field;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextEditor;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IconsTest
extends AbstratGenericEditorTest {
    private ExtensionBasedTextEditor genericEditor;
    private IFile testFile;
    private IProject testProject;

    @Test
    public void testEditorIconParentSet() throws Exception {
        this.testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClass().getName() + System.currentTimeMillis());
        this.testProject.create(null);
        this.testProject.open(null);
        this.testFile = this.testProject.getFile("foobar.txt");
        this.testFile.create("Testing file".getBytes(), 1, null);
        this.genericEditor = (ExtensionBasedTextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(this.testFile), "org.eclipse.ui.genericeditor.GenericEditor");
        Field field = this.genericEditor.getClass().getDeclaredField("contentTypeImageDescripter");
        field.setAccessible(true);
        ImageDescriptor descriptor = GenericEditorPlugin.getDefault().getContentTypeImagesRegistry().getImageDescriptor(new IContentType[]{Platform.getContentTypeManager().getContentType("org.eclipse.ui.genericeditor.tests.content-type")});
        Assertions.assertEquals((Object)field.get(this.genericEditor), (Object)descriptor);
    }

    @Test
    public void testEditorIconChildSet() throws Exception {
        this.testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClass().getName() + System.currentTimeMillis());
        this.testProject.create(null);
        this.testProject.open(null);
        this.testFile = this.testProject.getFile("foo.txt");
        this.testFile.create("Testing file".getBytes(), 1, null);
        this.genericEditor = (ExtensionBasedTextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(this.testFile), "org.eclipse.ui.genericeditor.GenericEditor");
        Field field = this.genericEditor.getClass().getDeclaredField("contentTypeImageDescripter");
        field.setAccessible(true);
        ImageDescriptor descriptor = GenericEditorPlugin.getDefault().getContentTypeImagesRegistry().getImageDescriptor(new IContentType[]{Platform.getContentTypeManager().getContentType("org.eclipse.ui.genericeditor.tests.sub-specialized-content-type")});
        Assertions.assertEquals((Object)field.get(this.genericEditor), (Object)descriptor);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.genericEditor != null) {
            this.genericEditor.close(false);
            this.genericEditor = null;
            DisplayHelper.runEventLoop((Display)PlatformUI.getWorkbench().getDisplay(), (long)0L);
        }
        if (this.testFile != null) {
            this.testFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            this.testFile = null;
        }
        if (this.testProject != null) {
            this.testProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
            this.testProject = null;
        }
        super.tearDown();
    }
}

