/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.genericeditor.tests.contributions.EnabledPropertyTester;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReconcilerTest
extends AbstratGenericEditorTest {
    protected ExtensionBasedTextEditor secondEditor;
    protected IFile secondFile;
    protected IProject secondProject;

    @Test
    public void testReconciler() throws Exception {
        this.performTestOnEditor("foo", this.editor, "BAR");
    }

    @Test
    public void testEnabledWhenReconciler() throws Exception {
        EnabledPropertyTester.setEnabled(true);
        this.createAndOpenFile("enabledWhen.txt", "");
        this.performTestOnEditor("foo", this.editor, "BAR");
        this.cleanFileAndEditor();
        EnabledPropertyTester.setEnabled(false);
        this.createAndOpenFile("enabledWhen.txt", "");
        this.performTestOnEditor("BAR", this.editor, "second");
    }

    @Test
    public void testMultipleEditors() throws Exception {
        this.secondProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClass().getName() + System.currentTimeMillis());
        this.secondProject.create(null);
        this.secondProject.open(null);
        this.secondFile = this.secondProject.getFile("foo.txt");
        this.secondFile.create("bar 'bar'".getBytes(), 1, null);
        this.secondEditor = (ExtensionBasedTextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(this.secondFile), "org.eclipse.ui.genericeditor.GenericEditor");
        this.performTestOnEditor("foo", this.editor, "BAR");
    }

    @Test
    public void testMultipleReconcilers() throws Exception {
        this.secondFile = this.project.getFile("bar.txt");
        this.secondFile.create("".getBytes(), 1, null);
        this.secondEditor = (ExtensionBasedTextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(this.secondFile), "org.eclipse.ui.genericeditor.GenericEditor");
        this.performTestOnEditor("foo", this.secondEditor, "second");
    }

    private void performTestOnEditor(String startingText, ExtensionBasedTextEditor textEditor, String expectedText) throws Exception {
        IDocumentProvider dp = textEditor.getDocumentProvider();
        IDocument doc = dp.getDocument((Object)textEditor.getEditorInput());
        doc.set(startingText);
        DisplayHelper.waitForCondition((Display)this.window.getShell().getDisplay(), (long)2000L, () -> {
            try {
                return doc.get(0, doc.getLineLength(0)).contains(expectedText);
            }
            catch (BadLocationException e) {
                return false;
            }
        });
        Assertions.assertTrue((boolean)doc.get().contains(expectedText), (String)"file was not affected by reconciler");
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.secondEditor != null) {
            this.secondEditor.close(false);
            this.secondEditor = null;
            DisplayHelper.runEventLoop((Display)PlatformUI.getWorkbench().getDisplay(), (long)0L);
        }
        if (this.secondFile != null) {
            this.secondFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            this.secondFile = null;
        }
        if (this.secondProject != null) {
            this.secondProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        super.tearDown();
    }
}

