/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.test.Screenshots;
import org.eclipse.text.tests.Accessor;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

@EnabledOnOs(value={OS.LINUX}, disabledReason="This test currently always fail on Windows and MacOS (bug 505842), skipping")
public class ShowInformationTest
extends AbstratGenericEditorTest {
    @Test
    public void testInformationControl(TestInfo info) throws Exception {
        Shell shell = this.getHoverShell(info, this.triggerCompletionAndRetrieveInformationControlManager(), true);
        Assertions.assertNotNull((Object)this.findControl((Control)shell, StyledText.class, "Alrighty!"));
    }

    private Shell getHoverShell(TestInfo info, AbstractInformationControlManager manager, boolean failOnError) {
        AbstractInformationControl[] control = new AbstractInformationControl[1];
        DisplayHelper.waitForCondition((Display)this.editor.getSite().getShell().getDisplay(), (long)5000L, () -> {
            abstractInformationControlArray[0] = (AbstractInformationControl)new Accessor((Object)manager, AbstractInformationControlManager.class).get("fInformationControl");
            return control[0] != null;
        });
        if (control[0] == null) {
            if (failOnError) {
                Screenshots.takeScreenshot(this.getClass(), (String)info.getDisplayName());
                Assertions.fail();
            } else {
                return null;
            }
        }
        boolean[] result = new boolean[1];
        Shell shell = control[0].getShell();
        DisplayHelper.waitForCondition((Display)control[0].getShell().getDisplay(), (long)2000L, () -> {
            blArray[0] = shell.isVisible();
            return blArray[0];
        });
        if (failOnError) {
            Assertions.assertTrue((boolean)shell.isVisible());
        }
        return shell;
    }

    private <T extends Control> T findControl(Control control, Class<T> controlType, String label) {
        if (control.getClass() == controlType) {
            Control res = control;
            if (label == null) {
                return (T)res;
            }
            String controlLabel = null;
            if (control instanceof Label) {
                Label l = (Label)control;
                controlLabel = l.getText();
            } else if (control instanceof Link) {
                Link link = (Link)control;
                controlLabel = link.getText();
            } else if (control instanceof Text) {
                Text text = (Text)control;
                controlLabel = text.getText();
            } else if (control instanceof StyledText) {
                StyledText styled = (StyledText)control;
                controlLabel = styled.getText();
            }
            if (controlLabel != null && controlLabel.contains(label)) {
                return (T)res;
            }
        } else if (control instanceof Composite) {
            Composite comp = (Composite)control;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                T res = this.findControl(child, controlType, label);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
        }
        return null;
    }

    private Object getShowInformationData(AbstractInformationControlManager manager) {
        return new Accessor((Object)manager, AbstractInformationControlManager.class).get("fInformation");
    }

    private AbstractInformationControlManager triggerCompletionAndRetrieveInformationControlManager() {
        int caretLocation = 2;
        this.editor.selectAndReveal(2, 0);
        StyledText editorTextWidget = (StyledText)this.editor.getAdapter(Control.class);
        DisplayHelper.waitForCondition((Display)editorTextWidget.getDisplay(), (long)3000L, () -> editorTextWidget.isFocusControl() && styledText.getSelection().x == 2);
        editorTextWidget.getShell().forceActive();
        editorTextWidget.getShell().setActive();
        editorTextWidget.getShell().setFocus();
        editorTextWidget.getShell().getDisplay().wake();
        ITextViewer viewer = (ITextViewer)this.editor.getAdapter(ITextViewer.class);
        ITextOperationTarget textOperationTarget = (ITextOperationTarget)viewer;
        Assertions.assertTrue((boolean)textOperationTarget.canDoOperation(16));
        textOperationTarget.doOperation(16);
        AbstractInformationControlManager informationControlManager = (AbstractInformationControlManager)new Accessor((Object)viewer, SourceViewer.class).get("fInformationPresenter");
        DisplayHelper.waitForCondition((Display)editorTextWidget.getDisplay(), (long)6000L, () -> this.getShowInformationData(informationControlManager) != null);
        return informationControlManager;
    }
}

