/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.genericeditor.tests.CompletionTest;
import org.eclipse.ui.genericeditor.tests.contributions.MarkerResolutionGenerator;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestQuickAssist
extends AbstratGenericEditorTest {
    private static final String FIXME_PROPOSAL = "org.eclipse.ui.genericeditor.tests.contributions.MarkerResolutionGenerator.fixme";
    private static final String DEFAULT_PROPOSAL = "QUICK ASSIST PROPOSAL";
    private Shell completionShell;

    @Test
    public void testCompletion() throws Exception {
        this.completionShell = this.openQuickAssist();
        Table completionProposalList = CompletionTest.findCompletionSelectionControl((Widget)this.completionShell);
        this.checkCompletionContent(completionProposalList, new String[]{DEFAULT_PROPOSAL});
    }

    @Test
    public void testMarkerQuickAssist() throws Exception {
        DisplayHelper.runEventLoop((Display)Display.getDefault(), (long)0L);
        IMarker marker = null;
        try {
            marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("lineNumber", 1);
            marker.setAttribute("charStart", 0);
            marker.setAttribute("charEnd", 5);
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)"We have a problem");
            marker.setAttribute(MarkerResolutionGenerator.FIXME, true);
            this.completionShell = this.openQuickAssist();
            Table completionProposalList = CompletionTest.findCompletionSelectionControl((Widget)this.completionShell);
            this.checkCompletionContent(completionProposalList, new String[]{DEFAULT_PROPOSAL, FIXME_PROPOSAL});
        }
        finally {
            if (marker != null && marker.exists()) {
                marker.delete();
            }
        }
    }

    @Test
    public void testMarkerQuickAssistLineOnly() throws Exception {
        DisplayHelper.runEventLoop((Display)Display.getDefault(), (long)0L);
        IMarker marker = null;
        try {
            marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("lineNumber", 1);
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)"We have a problem");
            marker.setAttribute(MarkerResolutionGenerator.FIXME, true);
            this.completionShell = this.openQuickAssist();
            Table completionProposalList = CompletionTest.findCompletionSelectionControl((Widget)this.completionShell);
            this.checkCompletionContent(completionProposalList, new String[]{DEFAULT_PROPOSAL, FIXME_PROPOSAL});
        }
        finally {
            if (marker != null && marker.exists()) {
                marker.delete();
            }
        }
    }

    private Shell openQuickAssist() {
        this.editor.selectAndReveal(3, 0);
        TextOperationAction action = (TextOperationAction)this.editor.getAction("QuickAssist");
        action.update();
        Set<Shell> beforeShells = Arrays.stream(this.editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        action.run();
        Shell shell = CompletionTest.findNewShell(beforeShells, this.editor.getSite().getShell().getDisplay(), true);
        DisplayHelper.runEventLoop((Display)PlatformUI.getWorkbench().getDisplay(), (long)100L);
        return shell;
    }

    private void checkCompletionContent(Table completionProposalList, String[] proposals) {
        DisplayHelper.waitForCondition((Display)completionProposalList.getDisplay(), (long)200L, () -> completionProposalList.getItemCount() >= proposals.length);
        Assertions.assertEquals((int)proposals.length, (int)completionProposalList.getItemCount());
        Set existing = Arrays.stream(completionProposalList.getItems()).map(TableItem::getText).collect(Collectors.toSet());
        String[] stringArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            String proposal = stringArray[n2];
            Assertions.assertTrue((boolean)existing.contains(proposal), (String)("Missing quick assist proposal '" + proposal + "', found " + String.valueOf(existing)));
            ++n2;
        }
    }

    @AfterEach
    public void closeShell() {
        if (this.completionShell != null && !this.completionShell.isDisposed()) {
            this.completionShell.close();
        }
    }
}

