/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests.contributions;

import java.util.Arrays;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class BarContentAssistProcessor
implements IContentAssistProcessor {
    public static final String BAR_CONTENT_ASSIST_PROPOSAL = "bars are good for a beer.";
    private final String completeString;

    public BarContentAssistProcessor() {
        this(BAR_CONTENT_ASSIST_PROPOSAL);
    }

    public BarContentAssistProcessor(String completeString) {
        this.completeString = completeString;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (viewer.getDocument() != null) {
            int offsetInProposal = Math.min(this.completeString.length(), viewer.getDocument().getLength());
            while (offsetInProposal > 0) {
                String maybeMatchingString = this.completeString.substring(0, offsetInProposal);
                try {
                    int lastIndex = offset - offsetInProposal + this.completeString.length();
                    if (offset >= offsetInProposal && viewer.getDocument().get(offset - offsetInProposal, maybeMatchingString.length()).equals(maybeMatchingString)) {
                        CompletionProposal proposal = new CompletionProposal(this.completeString.substring(offsetInProposal), offset, 0, lastIndex);
                        return new ICompletionProposal[]{proposal};
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                --offsetInProposal;
            }
        }
        return new ICompletionProposal[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        try {
            IDocument document = viewer.getDocument();
            int begin = offset;
            while (begin > 0 && Character.isLetterOrDigit(document.getChar(begin - 1))) {
                --begin;
            }
            if (begin < offset) {
                String word = document.get(begin, offset - begin);
                int idx = Arrays.asList(this.completeString.split("\\W")).indexOf(word);
                if (idx >= 0) {
                    return new IContextInformation[]{new ContextInformation(word, "idx= " + idx)};
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new IContextInformationValidator(){
            private ITextViewer viewer;
            private int offset;

            public void install(IContextInformation info, ITextViewer infoViewer, int documentOffset) {
                this.viewer = infoViewer;
                this.offset = documentOffset;
            }

            public boolean isContextInformationValid(int offsetToTest) {
                try {
                    IDocument document = this.viewer.getDocument();
                    IRegion line = document.getLineInformationOfOffset(this.offset);
                    int end = line.getOffset() + line.getLength();
                    return offsetToTest >= this.offset && offsetToTest < end;
                }
                catch (BadLocationException e) {
                    return false;
                }
            }
        };
    }

    public String getErrorMessage() {
        return null;
    }
}

