/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.tool.EclipseCompiler;

public class AnnotationProcessingCompilerToolTest
extends AbstractBatchCompilerTest {
    private File _extJar;
    static EclipseCompiler COMPILER = new EclipseCompiler();
    static JavaCompiler JAVAC_COMPILER = ToolProvider.getSystemJavaCompiler();

    public static Test suite() {
        return new TestSuite(AnnotationProcessingCompilerToolTest.class);
    }

    public AnnotationProcessingCompilerToolTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._extJar = TestUtil.createAndAddExternalAnnotationJar(null);
    }

    public void test_github844() throws IOException {
        this.runTest(true, new String[]{"X.java", "package p1;\n\n import org.eclipse.jdt.apt.tests.external.annotations.batch.*;\n import p1.gen.*;\n@BatchGen\npublic class X {   Class0 clazz0;\n   Class1 clazz1;\n}\n"}, null, Arrays.asList("-d", OUTPUT_DIR, "-source", CompilerOptions.getFirstSupportedJavaVersion(), "-g", "-preserveAllLocals", "-cp", OUTPUT_DIR + File.pathSeparator + this._extJar.getAbsolutePath(), "-s", OUTPUT_DIR + File.separator + "src-gen", "-processorpath", this._extJar.getAbsolutePath(), "-XprintProcessorInfo", "-XprintRounds", "-proceedOnError"), new String[]{"X.java"}, "Round 1:\n\tinput files: {p1.X}\n\tannotations: [org.eclipse.jdt.apt.tests.external.annotations.batch.BatchGen]\n\tlast round: false\nDiscovered processor service org.eclipse.jdt.apt.tests.external.annotations.batch.BatchGenProcessor\n  supporting [org.eclipse.jdt.apt.tests.external.annotations.batch.BatchGen]\n  in jar:" + Path.of(this._extJar.toPath().normalize().toAbsolutePath().toString(), new String[0]).toUri().toURL().toString() + "!/\nProcessor org.eclipse.jdt.apt.tests.external.annotations.batch.BatchGenProcessor matches [org.eclipse.jdt.apt.tests.external.annotations.batch.BatchGen] and returns true\nRound 2:\n\tinput files: {p1.gen.Class1,p1.gen.Class2,p1.Class0}\n\tannotations: []\n\tlast round: false\nProcessor org.eclipse.jdt.apt.tests.external.annotations.batch.BatchGenProcessor matches [] and returns false\nRound 3:\n\tinput files: {}\n\tannotations: []\n\tlast round: true\n", "", true);
    }

    public void test_github1654() throws IOException {
        this.runTest(true, new String[]{"X.java", "package p1;\nimport org.eclipse.jdt.apt.tests.external.annotations.batch.BatchGen;\n@BatchGen\npublic class X {\n}\n", "Anno.java", "package p1;\npublic @interface Anno {\n\tpublic static final String V = \"V\";\n\tString v() default \"\";\n}\n", "Breaks.java", "package p2;\nimport p1.Anno;\nimport p1.gen.Class1;\n@Anno (v = Anno.V)\npublic class Breaks {\n\tpublic Class1 c1;\n};\n", "Works1.java", "package p2;\nimport p1.Anno;\nimport p1.gen.Class1;\n@Anno // (v = Anno.V)\npublic class Works1 {\n\tpublic Class1 c1;\n};\n", "Works2.java", "package p2;\nimport p1.Anno;\n// import p1.gen.Class1;\n@Anno(v = Anno.V)\npublic class Works2 {\n\t// public Class1 c1;\n\tpublic p1.gen.Class1 c1;\n};\n"}, null, Arrays.asList("-d", OUTPUT_DIR, "-source", CompilerOptions.getFirstSupportedJavaVersion(), "-g", "-preserveAllLocals", "-cp", OUTPUT_DIR + File.pathSeparator + this._extJar.getAbsolutePath(), "-s", OUTPUT_DIR + File.separator + "src-gen", "-processorpath", this._extJar.getAbsolutePath(), "-XprintProcessorInfo", "-proceedOnError"), new String[]{"X.java", "Anno.java", "Breaks.java", "Works1.java", "Works2.java"}, "Discovered processor service org.eclipse.jdt.apt.tests.external.annotations.batch.BatchGenProcessor\n  supporting [org.eclipse.jdt.apt.tests.external.annotations.batch.BatchGen]\n  in jar:" + Path.of(this._extJar.toPath().normalize().toAbsolutePath().toString(), new String[0]).toUri().toURL().toString() + "!/\nProcessor org.eclipse.jdt.apt.tests.external.annotations.batch.BatchGenProcessor matches [org.eclipse.jdt.apt.tests.external.annotations.batch.BatchGen] and returns true\nProcessor org.eclipse.jdt.apt.tests.external.annotations.batch.BatchGenProcessor matches [] and returns false\n", "", true);
    }

    protected boolean invokeCompiler(PrintWriter out, PrintWriter err, Object extraArguments, AbstractBatchCompilerTest.TestCompilationProgress compilationProgress) {
        CompilerInvocationTestsArguments arguments = (CompilerInvocationTestsArguments)extraArguments;
        StandardJavaFileManager manager = arguments.standardJavaFileManager;
        boolean ownsManager = false;
        if (manager == null) {
            manager = COMPILER.getStandardFileManager(null, null, null);
            ownsManager = true;
        }
        try {
            ArrayList<File> files = new ArrayList<File>();
            String[] fileNames = arguments.fileNames;
            int i = 0;
            int l = fileNames.length;
            while (i < l) {
                if (fileNames[i].startsWith(OUTPUT_DIR)) {
                    files.add(new File(fileNames[i]));
                } else {
                    files.add(new File(OUTPUT_DIR + File.separator + fileNames[i]));
                }
                ++i;
            }
            JavaCompiler.CompilationTask task = COMPILER.getTask((Writer)out, (JavaFileManager)arguments.standardJavaFileManager, (DiagnosticListener)new CompilerInvocationDiagnosticListener(err), arguments.options, null, manager.getJavaFileObjectsFromFiles(files));
            boolean bl = task.call();
            return bl;
        }
        finally {
            try {
                if (ownsManager) {
                    manager.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void runTest(boolean shouldCompileOK, String[] sourceFiles, StandardJavaFileManager standardJavaFileManager, List<String> options, String[] compileFileNames, String expectedOutOutputString, String expectedErrOutputString, boolean shouldFlushOutputDirectory) {
        super.runTest(shouldCompileOK, sourceFiles, (Object)new CompilerInvocationTestsArguments(standardJavaFileManager, options, compileFileNames), expectedOutOutputString, expectedErrOutputString, shouldFlushOutputDirectory, null);
    }

    static class CompilerInvocationDiagnosticListener
    implements DiagnosticListener<JavaFileObject> {
        public static final int NONE = 0;
        public static final int ERROR = 1;
        public static final int INFO = 2;
        public static final int WARNING = 4;
        private final PrintWriter err;
        public int kind;

        public CompilerInvocationDiagnosticListener(PrintWriter err) {
            this.err = err;
            this.kind = 0;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            this.err.println(diagnostic.getMessage(Locale.getDefault()));
            if (this.kind == 0) {
                switch (diagnostic.getKind()) {
                    case ERROR: {
                        this.kind = 1;
                        break;
                    }
                    case WARNING: 
                    case MANDATORY_WARNING: {
                        this.kind = 4;
                        break;
                    }
                    case NOTE: 
                    case OTHER: {
                        this.kind = 2;
                    }
                }
            }
        }
    }

    protected static class CompilerInvocationTestsArguments {
        StandardJavaFileManager standardJavaFileManager;
        List<String> options;
        String[] fileNames;

        public CompilerInvocationTestsArguments(StandardJavaFileManager standardJavaFileManager, List<String> options, String[] fileNames) {
            this.standardJavaFileManager = standardJavaFileManager;
            this.options = options;
            this.fileNames = fileNames;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (String option : this.options) {
                result.append(option);
                result.append(' ');
            }
            return result.toString();
        }
    }

    public record JavacArguments(List<Path> classPath, Path classOutput, Path nativeHeaderOutput, List<Path> sourcePath, List<Path> sourceFiles, Path system, List<Path> bootClassPath, List<Path> processorPath, Path sourceOutput) {
    }
}

