/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedFileManager;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.jdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class AptReconcileTests
extends ModifyingResourceTests {
    IJavaProject _jproject;
    protected ICompilationUnit _workingCopy;
    protected AbstractJavaModelTests.ProblemRequestor _problemRequestor;
    private static String _testProject;
    private static String _testFolder;
    private static int _testProjectNum;
    private static final String TEST_PROJECT;

    static {
        _testProjectNum = 0;
        TEST_PROJECT = AptReconcileTests.class.getName() + "Project";
    }

    public AptReconcileTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(AptReconcileTests.class);
    }

    public void testGeneratedFile() throws Throwable {
        String fname = _testFolder + "/A.java";
        try {
            try {
                String codeWithErrors = "package test;\n//import org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class A \n{\n    //@HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        generatedfilepackage.GeneratedFileTest.helloWorld();\n    }\n}";
                this.createFile(fname, codeWithErrors);
                this._problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
                this.setUpWorkingCopy(fname, codeWithErrors);
                this._workingCopy.reconcile(0, true, null, null);
                String expectedProblems = "----------\n1. ERROR in /" + _testProject + "/src/test/A.java (at line 8)\n\tgeneratedfilepackage.GeneratedFileTest.helloWorld();\n\t^^^^^^^^^^^^^^^^^^^^\ngeneratedfilepackage cannot be resolved\n----------\n----------\n2. ERROR in /" + _testProject + "/src/test/A.java (at line 8)\n\tgeneratedfilepackage.GeneratedFileTest.helloWorld();\n\t^^^^^^^^^^^^^^^^^^^^\ngeneratedfilepackage cannot be resolved\n----------\n";
                this.assertProblems("Unexpected problems", expectedProblems);
                String codeWithOutErrors = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class A \n{\n    @HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        generatedfilepackage.GeneratedFileTest.helloWorld();\n    }\n}";
                this.setWorkingCopyContents(codeWithOutErrors);
                this._workingCopy.reconcile(0, true, null, null);
                this.assertProblems("UnexpectedProblems", "----------\n----------\n");
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            this.deleteFile(fname);
        }
    }

    public void testNestedGeneratedFile() throws Throwable {
        String fname = _testFolder + "/A.java";
        try {
            try {
                String codeWithErrors = "package test;\n//import org.eclipse.jdt.apt.tests.annotations.nestedhelloworld.NestedHelloWorldAnnotation;\npublic class A \n{\n    //@NestedHelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        generatedfilepackage.GeneratedFileTest.helloWorld();\n    }\n}";
                this.createFile(fname, codeWithErrors);
                this._problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
                this.setUpWorkingCopy(fname, codeWithErrors);
                this._workingCopy.reconcile(0, true, null, null);
                String expectedProblems = "----------\n1. ERROR in /" + _testProject + "/src/test/A.java (at line 8)\n\tgeneratedfilepackage.GeneratedFileTest.helloWorld();\n\t^^^^^^^^^^^^^^^^^^^^\ngeneratedfilepackage cannot be resolved\n----------\n----------\n2. ERROR in /" + _testProject + "/src/test/A.java (at line 8)\n\tgeneratedfilepackage.GeneratedFileTest.helloWorld();\n\t^^^^^^^^^^^^^^^^^^^^\ngeneratedfilepackage cannot be resolved\n----------\n";
                this.assertProblems("Unexpected problems", expectedProblems);
                String codeWithOutErrors = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.nestedhelloworld.NestedHelloWorldAnnotation;\npublic class A \n{\n    @NestedHelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        generatedfilepackage.GeneratedFileTest.helloWorld();\n    }\n}";
                this.setWorkingCopyContents(codeWithOutErrors);
                this._workingCopy.reconcile(0, true, null, null);
                this.assertProblems("UnexpectedProblems", "----------\n----------\n");
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            this.deleteFile(fname);
        }
    }

    public void testStopGeneratingFileInReconciler() throws Exception {
        String fname = _testFolder + "/A.java";
        try {
            String codeWithErrors = "package test;\n//import org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class A \n{\n    //@HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        generatedfilepackage.GeneratedFileTest.helloWorld();\n    }\n}";
            this.createFile(fname, codeWithErrors);
            this._problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.setUpWorkingCopy(fname, codeWithErrors);
            this._workingCopy.reconcile(0, true, null, null);
            String expectedProblems = "----------\n1. ERROR in /" + _testProject + "/src/test/A.java (at line 8)\n\tgeneratedfilepackage.GeneratedFileTest.helloWorld();\n\t^^^^^^^^^^^^^^^^^^^^\ngeneratedfilepackage cannot be resolved\n----------\n----------\n2. ERROR in /" + _testProject + "/src/test/A.java (at line 8)\n\tgeneratedfilepackage.GeneratedFileTest.helloWorld();\n\t^^^^^^^^^^^^^^^^^^^^\ngeneratedfilepackage cannot be resolved\n----------\n";
            this.assertProblems("Unexpected problems", expectedProblems);
            String codeWithOutErrors = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class A \n{\n    @HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        generatedfilepackage.GeneratedFileTest.helloWorld();\n    }\n}";
            this.setWorkingCopyContents(codeWithOutErrors);
            this._workingCopy.reconcile(0, true, null, null);
            this.assertProblems("UnexpectedProblems", "----------\n----------\n");
            this.setWorkingCopyContents(codeWithErrors);
            this._workingCopy.reconcile(0, true, null, null);
            String expectedProblems2 = "----------\n1. ERROR in /" + _testProject + "/src/test/A.java (at line 8)\n\tgeneratedfilepackage.GeneratedFileTest.helloWorld();\n\t^^^^^^^^^^^^^^^^^^^^\ngeneratedfilepackage cannot be resolved\n----------\n";
            this.assertProblems("Unexpected problems", expectedProblems2);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testDiscardParentWorkingCopy() throws Throwable {
        String fname = _testFolder + "/A.java";
        try {
            String codeWithOutErrors = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class A \n{\n    @HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        generatedfilepackage.GeneratedFileTest.helloWorld();\n    }\n}";
            this.createFile(fname, codeWithOutErrors);
            this._problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.setUpWorkingCopy(fname, codeWithOutErrors);
            this._problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this._workingCopy.reconcile(0, true, null, null);
            this.assertProblems("UnexpectedProblems", "");
            IJavaProject jp = this._workingCopy.getJavaProject();
            GeneratedFileManager gfm = AptPlugin.getAptProject((IJavaProject)jp).getGeneratedFileManager(false);
            if (!gfm.containsWorkingCopyMapEntriesForParent((IFile)this._workingCopy.getResource())) {
                AptReconcileTests.fail((String)"Expected to find map entries in GeneratedFileManager");
            }
            this._workingCopy.discardWorkingCopy();
            if (gfm.containsWorkingCopyMapEntriesForParent((IFile)this._workingCopy.getResource())) {
                AptReconcileTests.fail((String)"Unexpected map entries in GeneratedFileManager!");
            }
        }
        finally {
            this.deleteFile(fname);
        }
    }

    public void testBasicReconcile() throws Exception {
        String fname = _testFolder + "/X.java";
        try {
            String code = "package test;\n@org.eclipse.jdt.apt.tests.annotations.apitest.Common\npublic class X \n{\n    public static void main( String[] argv )\n    {\n    }\n}";
            this.createFile(fname, code);
            this._problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.setUpWorkingCopy(fname, code);
            this._workingCopy.reconcile(0, true, null, null);
            this.assertProblems("UnexpectedProblems", "----------\n----------\n----------\n----------\n");
        }
        finally {
            this.deleteFile(fname);
        }
    }

    public void testNoReconcile() throws Throwable {
        AptConfig.setProcessDuringReconcile((IJavaProject)this._jproject, (boolean)false);
        String fname = _testFolder + "/A.java";
        try {
            try {
                String codeWithErrors = "package test;\n//import org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class A \n{\n    //@HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        generatedfilepackage.GeneratedFileTest.helloWorld();\n    }\n}";
                this.createFile(fname, codeWithErrors);
                this._problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
                this.setUpWorkingCopy(fname, codeWithErrors);
                this._workingCopy.reconcile(0, true, null, null);
                String expectedProblems = "----------\n1. ERROR in /" + _testProject + "/src/test/A.java (at line 8)\n\tgeneratedfilepackage.GeneratedFileTest.helloWorld();\n\t^^^^^^^^^^^^^^^^^^^^\ngeneratedfilepackage cannot be resolved\n----------\n----------\n2. ERROR in /" + _testProject + "/src/test/A.java (at line 8)\n\tgeneratedfilepackage.GeneratedFileTest.helloWorld();\n\t^^^^^^^^^^^^^^^^^^^^\ngeneratedfilepackage cannot be resolved\n----------\n";
                this.assertProblems("Unexpected problems", expectedProblems);
                String codeWithOutErrors1 = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class A \n{\n    @HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        generatedfilepackage.GeneratedFileTest.helloWorld();\n    }\n}";
                this.setWorkingCopyContents(codeWithOutErrors1);
                this._workingCopy.reconcile(0, true, null, null);
                String expectedProblems2 = "----------\n1. ERROR in /" + _testProject + "/src/test/A.java (at line 8)\n\tgeneratedfilepackage.GeneratedFileTest.helloWorld();\n\t^^^^^^^^^^^^^^^^^^^^\ngeneratedfilepackage cannot be resolved\n----------\n";
                this.assertProblems("Unexpected problems", expectedProblems2);
                AptConfig.setProcessDuringReconcile((IJavaProject)this._jproject, (boolean)true);
                String codeWithOutErrors2 = "package test;\n\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class A \n{\n    @HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        generatedfilepackage.GeneratedFileTest.helloWorld();\n    }\n}";
                this.setWorkingCopyContents(codeWithOutErrors2);
                this._workingCopy.reconcile(0, true, null, null);
                this.assertProblems("UnexpectedProblems", "----------\n----------\n");
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            this.deleteFile(fname);
        }
    }

    public void setUp() throws Exception {
        _testProject = TEST_PROJECT + _testProjectNum;
        _testFolder = "/" + _testProject + "/src/test";
        AptPlugin.trace((String)("Setting up " + _testProject));
        super.setUp();
        String key = "description.autobuilding";
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putBoolean(key, false);
        this._problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
        IJavaProject project = this.createJavaProject(_testProject, new String[]{"src"}, new String[]{"JCL18_LIB"}, "bin", CompilerOptions.getFirstSupportedJavaVersion());
        TestUtil.createAndAddAnnotationJar(project);
        AptConfig.setEnabled((IJavaProject)project, (boolean)true);
        this.createFolder(_testFolder);
        this._jproject = project;
    }

    public void tearDown() throws Exception {
        this._jproject = null;
        AptPlugin.trace((String)("Tearing down " + _testProject));
        this.deleteProject(_testProject);
        super.tearDown();
    }

    private void setWorkingCopyContents(String contents) throws JavaModelException {
        this._workingCopy.getBuffer().setContents(contents);
        this._problemRequestor.initialize(contents.toCharArray());
    }

    private void setUpWorkingCopy(String path, String contents) throws JavaModelException {
        if (this._workingCopy != null) {
            this._workingCopy.discardWorkingCopy();
        }
        this._workingCopy = this.getCompilationUnit(path).getWorkingCopy(new WorkingCopyOwner(){}, (IProblemRequestor)this._problemRequestor, null);
        this.setWorkingCopyContents(contents);
        this._workingCopy.makeConsistent(null);
    }

    protected void assertProblems(String message, String expected) {
        this.assertProblems(message, expected, this._problemRequestor);
    }
}

