/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.ExecutableDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.annotations.generic.AbstractGenericProcessor;
import org.eclipse.jdt.apt.tests.annotations.generic.GenericFactory;

public class DeclarationVisitorTests
extends APTTestBase {
    Cases testCaseIdentifier;
    ArrayList<Declaration> declarationsVisited = new ArrayList();
    final String code = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.generic.*;\n@GenericAnnotation public class Test\n{\n    Test() {}\n    String s;\n    class C {}\n    class P<T> {}\n    interface I {}\n    void m(int i) {}\n    enum E { elephant }\n    @interface A { String strValue() default \"\"; }\n}";

    public DeclarationVisitorTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(DeclarationVisitorTests.class);
    }

    public void testPackageDeclarationVisitor() {
        this.testCaseIdentifier = Cases.PackageDeclaration;
        this.runProcessorBasedTest();
    }

    public void testClassDeclarationVisitor() {
        this.testCaseIdentifier = Cases.ClassDeclaration;
        this.runProcessorBasedTest();
    }

    public void testEnumDeclarationVisitor() {
        this.testCaseIdentifier = Cases.EnumDeclaration;
        this.runProcessorBasedTest();
    }

    public void testInterfaceDeclarationVisitor() {
        this.testCaseIdentifier = Cases.InterfaceDeclaration;
        this.runProcessorBasedTest();
    }

    public void testAnnotationTypeDeclarationVisitor() {
        this.testCaseIdentifier = Cases.AnnotationTypeDeclaration;
        this.runProcessorBasedTest();
    }

    public void testFieldDeclarationVisitor() {
        this.testCaseIdentifier = Cases.FieldDeclaration;
        this.runProcessorBasedTest();
    }

    public void testEnumConstantDeclarationVisitor() {
        this.testCaseIdentifier = Cases.EnumConstantDeclaration;
        this.runProcessorBasedTest();
    }

    public void testConstructorDeclarationVisitor() {
        this.testCaseIdentifier = Cases.ConstructorDeclaration;
        this.runProcessorBasedTest();
    }

    public void testMethodDeclarationVisitor() {
        this.testCaseIdentifier = Cases.MethodDeclaration;
        this.runProcessorBasedTest();
    }

    public void testAnnotationTypeElementDeclarationVisitor() {
        this.testCaseIdentifier = Cases.AnnotationTypeElementDeclaration;
        this.runProcessorBasedTest();
    }

    public void testParameterDeclarationVisitor() {
        this.testCaseIdentifier = Cases.ParameterDeclaration;
        this.runProcessorBasedTest();
    }

    public void testTypeParameterDeclarationVisitor() {
        this.testCaseIdentifier = Cases.TypeParameterDeclaration;
        this.runProcessorBasedTest();
    }

    void runProcessorBasedTest() {
        DeclarationVisitorProc p = new DeclarationVisitorProc();
        GenericFactory.PROCESSOR = p;
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        env.addClass(srcRoot, "test", "Test", "package test;\nimport org.eclipse.jdt.apt.tests.annotations.generic.*;\n@GenericAnnotation public class Test\n{\n    Test() {}\n    String s;\n    class C {}\n    class P<T> {}\n    interface I {}\n    void m(int i) {}\n    enum E { elephant }\n    @interface A { String strValue() default \"\"; }\n}");
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        DeclarationVisitorTests.assertTrue((String)"Processor not invoked", (boolean)p.called);
    }

    void declarationVisited(Declaration d) {
        this.declarationsVisited.add(d);
    }

    void initDeclVisitList() {
        if (this.declarationsVisited.size() > 0) {
            this.declarationsVisited.clear();
        }
    }

    static enum Cases {
        PackageDeclaration,
        ClassDeclaration,
        EnumDeclaration,
        InterfaceDeclaration,
        AnnotationTypeDeclaration,
        FieldDeclaration,
        EnumConstantDeclaration,
        ConstructorDeclaration,
        MethodDeclaration,
        AnnotationTypeElementDeclaration,
        ParameterDeclaration,
        TypeParameterDeclaration;

    }

    class DeclarationVisitorImpl
    implements DeclarationVisitor {
        DeclarationVisitorImpl() {
        }

        public void visitDeclaration(Declaration d) {
            DeclarationVisitorTests.fail((String)("Should never visit a Declaration, only a subclass: " + String.valueOf(d)));
        }

        public void visitPackageDeclaration(PackageDeclaration d) {
            DeclarationVisitorTests.this.declarationVisited((Declaration)d);
        }

        public void visitMemberDeclaration(MemberDeclaration d) {
            DeclarationVisitorTests.fail((String)("Should never visit a Member, only a subclass: " + String.valueOf(d)));
        }

        public void visitTypeDeclaration(TypeDeclaration d) {
            DeclarationVisitorTests.fail((String)("Should never visit a Type, only a subclass: " + String.valueOf(d)));
        }

        public void visitClassDeclaration(ClassDeclaration d) {
            DeclarationVisitorTests.this.declarationVisited((Declaration)d);
        }

        public void visitEnumDeclaration(EnumDeclaration d) {
            DeclarationVisitorTests.this.declarationVisited((Declaration)d);
        }

        public void visitInterfaceDeclaration(InterfaceDeclaration d) {
            DeclarationVisitorTests.this.declarationVisited((Declaration)d);
        }

        public void visitAnnotationTypeDeclaration(AnnotationTypeDeclaration d) {
            DeclarationVisitorTests.this.declarationVisited((Declaration)d);
        }

        public void visitFieldDeclaration(FieldDeclaration d) {
            DeclarationVisitorTests.this.declarationVisited((Declaration)d);
        }

        public void visitEnumConstantDeclaration(EnumConstantDeclaration d) {
            DeclarationVisitorTests.this.declarationVisited((Declaration)d);
        }

        public void visitExecutableDeclaration(ExecutableDeclaration d) {
            DeclarationVisitorTests.fail((String)("Should never visit an ExecutableDeclaration, only a subclass: " + String.valueOf(d)));
        }

        public void visitConstructorDeclaration(ConstructorDeclaration d) {
            DeclarationVisitorTests.this.declarationVisited((Declaration)d);
        }

        public void visitMethodDeclaration(MethodDeclaration d) {
            DeclarationVisitorTests.this.declarationVisited((Declaration)d);
        }

        public void visitAnnotationTypeElementDeclaration(AnnotationTypeElementDeclaration d) {
            DeclarationVisitorTests.this.declarationVisited((Declaration)d);
        }

        public void visitParameterDeclaration(ParameterDeclaration d) {
            DeclarationVisitorTests.this.declarationVisited((Declaration)d);
        }

        public void visitTypeParameterDeclaration(TypeParameterDeclaration d) {
            DeclarationVisitorTests.this.declarationVisited((Declaration)d);
        }
    }

    class DeclarationVisitorProc
    extends AbstractGenericProcessor {
        boolean called;

        DeclarationVisitorProc() {
        }

        public void _process() {
            this.called = true;
            DeclarationVisitorTests.assertTrue((this.decls.size() == 1 ? 1 : 0) != 0);
            DeclarationVisitorTests.this.initDeclVisitList();
            TypeDeclaration typeDecl = (TypeDeclaration)this.env.getTypeDeclarations().iterator().next();
            Collection nestedTypes = typeDecl.getNestedTypes();
            ClassDeclaration classDecl = null;
            EnumDeclaration enumDecl = null;
            InterfaceDeclaration interfaceDecl = null;
            AnnotationTypeDeclaration annoTypeDecl = null;
            EnumConstantDeclaration enumConstantDecl = null;
            MethodDeclaration methodDecl = null;
            switch (DeclarationVisitorTests.this.testCaseIdentifier) {
                case PackageDeclaration: {
                    PackageDeclaration packageDecl = typeDecl.getPackage();
                    packageDecl.accept((DeclarationVisitor)new DeclarationVisitorImpl());
                    DeclarationVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)DeclarationVisitorTests.this.declarationsVisited.size());
                    DeclarationVisitorTests.assertEquals((String)"Expected PackageDeclaration visitor", (String)"PackageDeclarationImpl", (String)DeclarationVisitorTests.this.declarationsVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case ClassDeclaration: {
                    for (TypeDeclaration tempDecl : nestedTypes) {
                        if (!tempDecl.getSimpleName().equals("C")) continue;
                        classDecl = (ClassDeclaration)tempDecl;
                    }
                    classDecl.accept((DeclarationVisitor)new DeclarationVisitorImpl());
                    DeclarationVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)DeclarationVisitorTests.this.declarationsVisited.size());
                    DeclarationVisitorTests.assertEquals((String)"Expected ClassDeclaration visitor", (String)"ClassDeclarationImpl", (String)DeclarationVisitorTests.this.declarationsVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case EnumDeclaration: {
                    for (TypeDeclaration tempDecl : nestedTypes) {
                        if (!tempDecl.getSimpleName().equals("E")) continue;
                        enumDecl = (EnumDeclaration)tempDecl;
                    }
                    enumDecl.accept((DeclarationVisitor)new DeclarationVisitorImpl());
                    DeclarationVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)DeclarationVisitorTests.this.declarationsVisited.size());
                    DeclarationVisitorTests.assertEquals((String)"Expected EnumDeclaration visitor", (String)"EnumDeclarationImpl", (String)DeclarationVisitorTests.this.declarationsVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case InterfaceDeclaration: {
                    for (TypeDeclaration tempDecl : nestedTypes) {
                        if (!tempDecl.getSimpleName().equals("I")) continue;
                        interfaceDecl = (InterfaceDeclaration)tempDecl;
                    }
                    interfaceDecl.accept((DeclarationVisitor)new DeclarationVisitorImpl());
                    DeclarationVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)DeclarationVisitorTests.this.declarationsVisited.size());
                    DeclarationVisitorTests.assertEquals((String)"Expected InterfaceDeclaration visitor", (String)"InterfaceDeclarationImpl", (String)DeclarationVisitorTests.this.declarationsVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case AnnotationTypeDeclaration: {
                    for (TypeDeclaration tempDecl : nestedTypes) {
                        if (!tempDecl.getSimpleName().equals("A")) continue;
                        annoTypeDecl = (AnnotationTypeDeclaration)tempDecl;
                    }
                    annoTypeDecl.accept((DeclarationVisitor)new DeclarationVisitorImpl());
                    DeclarationVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)DeclarationVisitorTests.this.declarationsVisited.size());
                    DeclarationVisitorTests.assertEquals((String)"Expected AnnotationTypeDeclaration visitor", (String)"AnnotationDeclarationImpl", (String)DeclarationVisitorTests.this.declarationsVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case FieldDeclaration: {
                    FieldDeclaration fieldDecl = (FieldDeclaration)typeDecl.getFields().iterator().next();
                    fieldDecl.accept((DeclarationVisitor)new DeclarationVisitorImpl());
                    DeclarationVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)DeclarationVisitorTests.this.declarationsVisited.size());
                    DeclarationVisitorTests.assertEquals((String)"Expected FieldDeclaration visitor", (String)"FieldDeclarationImpl", (String)DeclarationVisitorTests.this.declarationsVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case EnumConstantDeclaration: {
                    for (TypeDeclaration tempDecl : nestedTypes) {
                        if (!tempDecl.getSimpleName().equals("E")) continue;
                        enumDecl = (EnumDeclaration)tempDecl;
                    }
                    enumConstantDecl = (EnumConstantDeclaration)enumDecl.getEnumConstants().iterator().next();
                    enumConstantDecl.accept((DeclarationVisitor)new DeclarationVisitorImpl());
                    DeclarationVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)DeclarationVisitorTests.this.declarationsVisited.size());
                    DeclarationVisitorTests.assertEquals((String)"Expected EnumConstantDeclaration visitor", (String)"EnumConstantDeclarationImpl", (String)DeclarationVisitorTests.this.declarationsVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case ConstructorDeclaration: {
                    for (TypeDeclaration tempDecl : nestedTypes) {
                        if (!tempDecl.getSimpleName().equals("C")) continue;
                        classDecl = (ClassDeclaration)tempDecl;
                    }
                    ConstructorDeclaration constructorDecl = (ConstructorDeclaration)classDecl.getConstructors().iterator().next();
                    constructorDecl.accept((DeclarationVisitor)new DeclarationVisitorImpl());
                    DeclarationVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)DeclarationVisitorTests.this.declarationsVisited.size());
                    DeclarationVisitorTests.assertEquals((String)"Expected ConstructorDeclaration visitor", (String)"ConstructorDeclarationImpl", (String)DeclarationVisitorTests.this.declarationsVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case MethodDeclaration: {
                    methodDecl = (MethodDeclaration)typeDecl.getMethods().iterator().next();
                    methodDecl.accept((DeclarationVisitor)new DeclarationVisitorImpl());
                    DeclarationVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)DeclarationVisitorTests.this.declarationsVisited.size());
                    DeclarationVisitorTests.assertEquals((String)"Expected MethodDeclaration visitor", (String)"MethodDeclarationImpl", (String)DeclarationVisitorTests.this.declarationsVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case AnnotationTypeElementDeclaration: {
                    for (TypeDeclaration tempDecl : nestedTypes) {
                        if (!tempDecl.getSimpleName().equals("A")) continue;
                        annoTypeDecl = (AnnotationTypeDeclaration)tempDecl;
                    }
                    AnnotationTypeElementDeclaration annoTypeElementDecl = (AnnotationTypeElementDeclaration)annoTypeDecl.getMethods().iterator().next();
                    annoTypeElementDecl.accept((DeclarationVisitor)new DeclarationVisitorImpl());
                    DeclarationVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)DeclarationVisitorTests.this.declarationsVisited.size());
                    DeclarationVisitorTests.assertEquals((String)"Expected AnnotationTypeElementDeclaration visitor", (String)"AnnotationElementDeclarationImpl", (String)DeclarationVisitorTests.this.declarationsVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case ParameterDeclaration: {
                    methodDecl = (MethodDeclaration)typeDecl.getMethods().iterator().next();
                    ParameterDeclaration paramDecl = (ParameterDeclaration)methodDecl.getParameters().iterator().next();
                    paramDecl.accept((DeclarationVisitor)new DeclarationVisitorImpl());
                    DeclarationVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)DeclarationVisitorTests.this.declarationsVisited.size());
                    DeclarationVisitorTests.assertEquals((String)"Expected ParameterDeclaration visitor", (String)"SourceParameterDeclarationImpl", (String)DeclarationVisitorTests.this.declarationsVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case TypeParameterDeclaration: {
                    for (TypeDeclaration tempDecl : nestedTypes) {
                        if (!tempDecl.getSimpleName().equals("P")) continue;
                        classDecl = (ClassDeclaration)tempDecl;
                    }
                    TypeParameterDeclaration typeParamDecl = (TypeParameterDeclaration)classDecl.getFormalTypeParameters().iterator().next();
                    typeParamDecl.accept((DeclarationVisitor)new DeclarationVisitorImpl());
                    DeclarationVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)DeclarationVisitorTests.this.declarationsVisited.size());
                    DeclarationVisitorTests.assertEquals((String)"Expected TypeParameterDeclaration visitor", (String)"TypeParameterDeclarationImpl", (String)DeclarationVisitorTests.this.declarationsVisited.get(0).getClass().getSimpleName());
                }
            }
        }
    }
}

