/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.internal.VarJarFactoryContainer;
import org.eclipse.jdt.apt.core.internal.WkspJarFactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.apt.core.internal.util.FactoryPathUtil;

public class FactoryPathTests
extends TestCase {
    private FactoryPath path;
    private final String[] filesInPath = new String[]{"all/your.jar", "base.jar", "are.jar", "belong/to/us.jar", "you/have/no/chance.jar", "to.jar", "survive.jar"};

    public FactoryPathTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(FactoryPathTests.class);
    }

    private static void assertExtJars(List<String> expected, Map<FactoryContainer, FactoryPath.Attributes> actual) {
        ArrayList<FactoryContainer> toIterate = new ArrayList<FactoryContainer>();
        toIterate.addAll(actual.keySet());
        Collections.reverse(toIterate);
        FactoryPathTests.assertEquals((String)"The size of the path list should match up", (int)expected.size(), (int)toIterate.size());
        int index = 0;
        for (FactoryContainer container : toIterate) {
            FactoryContainer fc = FactoryPathUtil.newExtJarFactoryContainer((File)new File(expected.get(index++)));
            FactoryPathTests.assertEquals((String)"Unexpected jar file", (Object)fc, (Object)container);
        }
    }

    protected void setUp() throws Exception {
        this.path = new FactoryPath();
        String[] stringArray = this.filesInPath;
        int n = this.filesInPath.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            this.path.addExternalJar(new File(next));
            ++n2;
        }
        super.setUp();
    }

    public void testGetAllContainers() throws Exception {
        FactoryPathTests.assertExtJars(Arrays.asList(this.filesInPath), this.path.getAllContainers());
    }

    public void testGetEnabledContainersOrder() throws Exception {
        FactoryPathTests.assertExtJars(Arrays.asList(this.filesInPath), this.path.getEnabledContainers());
    }

    public void testRemoveExternalJar() throws Exception {
        File toRemove = new File(this.filesInPath[3]);
        FactoryContainer fc = FactoryPathUtil.newExtJarFactoryContainer((File)toRemove);
        FactoryPathTests.assertTrue((String)"Initial classpath should have contained jar", (boolean)this.path.getAllContainers().containsKey(fc));
        this.path.removeExternalJar(toRemove);
        FactoryPathTests.assertFalse((String)"Final classpath should not have contained jar", (boolean)this.path.getAllContainers().containsKey(fc));
        String[] expectedResult = new String[]{"all/your.jar", "base.jar", "are.jar", "you/have/no/chance.jar", "to.jar", "survive.jar"};
        FactoryPathTests.assertExtJars(Arrays.asList(expectedResult), this.path.getAllContainers());
    }

    public void testAddRemoveVarJar() throws Exception {
        Path toAdd = new Path("/foo/bar/baz.jar");
        this.path.addVarJar((IPath)toAdd);
        VarJarFactoryContainer fc = (VarJarFactoryContainer)this.path.getAllContainers().keySet().iterator().next();
        FactoryPathTests.assertEquals((String)toAdd.toString(), (String)fc.getId());
        this.path.removeVarJar((IPath)toAdd);
        FactoryPathTests.assertFalse((String)"Factory path should not contain the removed jar", (boolean)this.path.getAllContainers().containsKey(fc));
    }

    public void testAddRemoveWorkspaceJar() throws Exception {
        Path toAdd = new Path("/foo/bar/baz.jar");
        this.path.addWkspJar((IPath)toAdd);
        WkspJarFactoryContainer fc = (WkspJarFactoryContainer)this.path.getAllContainers().keySet().iterator().next();
        FactoryPathTests.assertTrue((boolean)fc.getJarFile().toString().endsWith(toAdd.toOSString()));
        this.path.removeWkspJar((IPath)toAdd);
        FactoryPathTests.assertFalse((String)"Factory path should not contain the removed jar", (boolean)this.path.getAllContainers().containsKey(fc));
    }

    public void testSetContainers() throws Exception {
        FactoryPath newPath = new FactoryPath();
        newPath.setContainers(this.path.getAllContainers());
        FactoryPathTests.assertExtJars(Arrays.asList(this.filesInPath), newPath.getAllContainers());
    }
}

