/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.SourcePosition;
import java.util.Collection;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.env.EnvironmentFactory;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.ExpectedProblem;
import org.eclipse.jdt.apt.tests.annotations.ProcessorTestStatus;
import org.eclipse.jdt.apt.tests.annotations.generic.AbstractGenericProcessor;
import org.eclipse.jdt.apt.tests.annotations.generic.GenericFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class MirrorDeclarationTests
extends APTTestBase {
    public MirrorDeclarationTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(MirrorDeclarationTests.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String code = "package mirrortestpackage;\nimport org.eclipse.jdt.apt.tests.annotations.mirrortest.MirrorDeclarationTestAnnotation;\n@MirrorDeclarationTestAnnotation(s=\"fred\", value=5)\npublic class DeclarationTestClass {\n\tpublic class ClassDec {\n\t\tpublic ClassDec() {}\n\t\tpublic ClassDec(int j) {}\n\t\tpublic static final int i = 1;\n\t\tpublic float f;\n\t\tpublic static final String s = \"hello\";\n\t\tpublic java.util.GregorianCalendar gc;\n\t\tpublic void methodDec(int k, String... t) throws Exception {}\n\t\tpublic void methodDecNoArg(){}\n\t\t@MirrorDeclarationTestAnnotation() public Object foo(Object o) throws Exception {\n\t\t\treturn null;\n\t\t}\n\t\t@MirrorDeclarationTestAnnotation() public Object foo2(Object o) throws Exception {\n\t\t\treturn null;\n\t\t}\n\t\t@MirrorDeclarationTestAnnotation() public Object foo3(Object o) throws Exception {\n\t\t\treturn null;\n\t\t}\n\t}\n\tpublic enum EnumDec {\n\t\taardvark, anteater\n\t}\n}";
        env.addClass(srcRoot, "mirrortestpackage", "DeclarationTestClass", code);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
    }

    public void testMirrorDeclaration() throws Exception {
        MirrorDeclarationTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testFieldConstant() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String codeTrigger = "package test;\npublic @interface Trigger{}";
        env.addClass(srcRoot, "test", "Trigger", codeTrigger);
        String codeEntryPoint = "package test;\n@Trigger\npublic class EntryPoint {\n    ClassWithNestedAnnotation nestedAnno;\n}";
        env.addClass(srcRoot, "test", "EntryPoint", codeEntryPoint);
        String codeClassWithNestedAnnotation = "package test; \npublic class ClassWithNestedAnnotation {\n\tpublic final int FOUR = 4; \n }";
        env.addClass(srcRoot, "test", "ClassWithNestedAnnotation", codeClassWithNestedAnnotation);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
    }

    public void DISABLED_testDefault() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String codeTrigger = "package test;\npublic @interface Trigger{}";
        env.addClass(srcRoot, "test", "Trigger", codeTrigger);
        String codeEntryPoint = "package test;\n@Trigger\npublic class EntryPoint {\n    ClassWithNestedAnnotation nestedAnno;\n}";
        env.addClass(srcRoot, "test", "EntryPoint", codeEntryPoint);
        String codeClassWithNestedAnnotation = "package test; \npublic class ClassWithNestedAnnotation {\n\tpublic @interface NestedAnnotation{\n\t\tpublic enum Character{ \n\t\t\tWinnie, Tiger, Piglet, Eore; \n\t\t}\n\t\tCharacter value() default Character.Eore; \n\t}\n}";
        env.addClass(srcRoot, "test", "ClassWithNestedAnnotation", codeClassWithNestedAnnotation);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
    }

    public void testUnresolvableDeclarations0() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String declAnno = "package test;\npublic @interface DeclarationAnno{}";
        env.addClass(srcRoot, "test", "DeclarationAnno", declAnno);
        String codeFoo = "package test;\n@DeclarationAnno\npublic class Foo {\n    int field0;\n     UnknownType field1;\n     public Foo(UnknownType type){} \n    public void voidMethod(){} \n     public UnknownType getType(){}\n     public class Inner{} \n}";
        IPath fooPath = env.addClass(srcRoot, "test", "Foo", codeFoo);
        this.fullBuild(project.getFullPath());
        this.expectingOnlySpecificProblemsFor(fooPath, new ExpectedProblem[]{new ExpectedProblem("", "UnknownType cannot be resolved to a type", fooPath), new ExpectedProblem("", "UnknownType cannot be resolved to a type", fooPath), new ExpectedProblem("", "UnknownType cannot be resolved to a type", fooPath)});
    }

    public void testUnresolvableDeclarations1() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String declAnno = "package test;\npublic @interface DeclarationAnno{}";
        env.addClass(srcRoot, "test", "DeclarationAnno", declAnno);
        String codeBar = "package test;\n@DeclarationAnno\npublic class Bar {}";
        env.addClass(srcRoot, "test", "Bar", codeBar);
        String codeFoo = "package test;\n@DeclarationAnno\npublic class Foo {\n    int field0;\n     UnknownType field1;\n     public Foo(UnknownType type){} \n    public void voidMethod(){} \n     public UnknownType getType(){}\n     public class Inner{} \n}";
        IPath fooPath = env.addClass(srcRoot, "test", "Foo", codeFoo);
        this.fullBuild(project.getFullPath());
        this.expectingOnlySpecificProblemsFor(fooPath, new ExpectedProblem[]{new ExpectedProblem("", "UnknownType cannot be resolved to a type", fooPath), new ExpectedProblem("", "UnknownType cannot be resolved to a type", fooPath), new ExpectedProblem("", "UnknownType cannot be resolved to a type", fooPath)});
    }

    public void testLocation() {
        TestLocationProc p = new TestLocationProc();
        GenericFactory.setProcessor((AbstractGenericProcessor)p);
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String x = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.generic.*;\n@GenericAnnotation public class X {}";
        env.addClass(srcRoot, "test", "X", x);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        MirrorDeclarationTests.assertTrue((String)"Processor not invoked", (boolean)p.called);
    }

    public void testSourceMirror() {
        TestSourceMirrorProc p = new TestSourceMirrorProc();
        GenericFactory.setProcessor((AbstractGenericProcessor)p);
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        env.addClass(srcRoot, "mirrortestpackage", "SourceAnnotation", "package mirrortestpackage;\n\n@interface SourceAnnotation {\n    String value() default \"def\";\n}\n");
        env.addClass(srcRoot, "mirrortestpackage", "MirrorTestClass2", "package mirrortestpackage;\n\nimport org.eclipse.jdt.apt.tests.annotations.generic.*;\n@GenericAnnotation\n@SourceAnnotation(\"nondef\")\npublic class MirrorTestClass2 {\n}");
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        MirrorDeclarationTests.assertTrue((String)"Processor not invoked", (boolean)p.called);
    }

    public void testPackageInfo() {
        PackageInfoProc p = new PackageInfoProc();
        GenericFactory.setProcessor((AbstractGenericProcessor)p);
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        IPath pkg = env.addPackage(srcRoot, "pkg");
        String contents = "@PkgAnnotation\n@GenericAnnotation\npackage pkg;\nimport org.eclipse.jdt.apt.tests.annotations.generic.*;";
        env.addFile(pkg, "package-info.java", contents);
        String annContents = "package pkg;\n\n@interface PkgAnnotation {\n    String value() default \"def\";\n}\n";
        env.addClass(srcRoot, "pkg", "pkgAnnotation", annContents);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        MirrorDeclarationTests.assertTrue((String)"Processor not invoked", (boolean)p.called);
    }

    public void testEnvFactory() throws JavaModelException {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String x = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.generic.*;\n@GenericAnnotation public class X {}";
        IPath path = env.addClass(srcRoot, "test", "X", x);
        IPath tail = path.removeFirstSegments(2);
        IJavaProject p = JavaCore.create((IProject)project);
        ICompilationUnit cu = (ICompilationUnit)p.findElement(tail);
        MirrorDeclarationTests.assertNotNull((String)"Could not find cu", (Object)cu);
        AnnotationProcessorEnvironment env = EnvironmentFactory.getEnvironment((ICompilationUnit)cu, (IJavaProject)p);
        TypeDeclaration t = env.getTypeDeclaration("test.X");
        SourcePosition pos = t.getPosition();
        MirrorDeclarationTests.assertEquals((int)32, (int)pos.column());
        MirrorDeclarationTests.assertEquals((int)3, (int)pos.line());
        TypeDeclaration tBad = env.getTypeDeclaration("test.XYZ");
        MirrorDeclarationTests.assertNull((Object)tBad);
    }

    static class PackageInfoProc
    extends AbstractGenericProcessor {
        boolean called;

        PackageInfoProc() {
        }

        public void _process() {
            this.called = true;
            AnnotationTypeDeclaration annoDecl = (AnnotationTypeDeclaration)this.env.getTypeDeclaration("pkg.PkgAnnotation");
            MirrorDeclarationTests.assertNotNull((String)"Type declaration 'pkg.PkgAnnotation' not found!", (Object)annoDecl);
            Collection annotatedDecls = this.env.getDeclarationsAnnotatedWith(annoDecl);
            MirrorDeclarationTests.assertTrue((annotatedDecls == null || annotatedDecls.size() == 0 ? 1 : 0) != 0);
        }
    }

    static class TestLocationProc
    extends AbstractGenericProcessor {
        boolean called;

        TestLocationProc() {
        }

        public void _process() {
            this.called = true;
            MirrorDeclarationTests.assertEquals((int)1, (int)this.decls.size());
            Declaration d = (Declaration)this.decls.iterator().next();
            SourcePosition p = d.getPosition();
            MirrorDeclarationTests.assertEquals((int)32, (int)p.column());
            MirrorDeclarationTests.assertEquals((int)3, (int)p.line());
        }
    }

    static class TestSourceMirrorProc
    extends AbstractGenericProcessor {
        boolean called;

        TestSourceMirrorProc() {
        }

        public void _process() {
            this.called = true;
            TypeDeclaration tdCode = this.env.getTypeDeclaration("mirrortestpackage.MirrorTestClass2");
            for (AnnotationMirror am : tdCode.getAnnotationMirrors()) {
                if ("GenericAnnotation".equals(am.getAnnotationType().getDeclaration().getSimpleName())) continue;
                MirrorDeclarationTests.assertNotNull((Object)am.getPosition());
                AnnotationTypeDeclaration atd = am.getAnnotationType().getDeclaration();
                MirrorDeclarationTests.assertNotNull((Object)atd.getPosition());
                for (Map.Entry entry : am.getElementValues().entrySet()) {
                    MirrorDeclarationTests.assertNotNull((Object)((AnnotationTypeElementDeclaration)entry.getKey()).getPosition());
                    MirrorDeclarationTests.assertNotNull((Object)((AnnotationTypeElementDeclaration)entry.getKey()).getDefaultValue().getPosition());
                }
            }
        }
    }
}

