/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.ExpectedProblem;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.apt.tests.annotations.ProcessorTestStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class MirrorTests
extends APTTestBase {
    public MirrorTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(MirrorTests.class);
    }

    public void testMirror() throws Exception {
        ProcessorTestStatus.reset();
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String code = "package mirrortestpackage;\n\nimport java.io.Serializable;\nimport org.eclipse.jdt.apt.tests.annotations.mirrortest.MirrorTestAnnotation;\n\npublic class MirrorTestClass implements Serializable {\n\n    public static final String STATIC_FIELD = \"Static Field\";\n\n    private static final long serialVersionUID = 42L;\n\n    public String field;\n\n    public MirrorTestClass() {\n        field = \"Field\";\n    }\n\n    @MirrorTestAnnotation\n    public static Object staticMethod() {\n        return null;\n    }\n\n    public String stringMethod() {\n        return null;\n    }\n\n\n    public String toString() {\n        return null;\n    }\n\n    public static class InnerClass extends MirrorTestClass {\n\n        private static final long serialVersionUID = 148L;\n\n        public static Object staticMethod() {\n            return null;\n        }\n\n    }\n}";
        env.addClass(srcRoot, "mirrortestpackage", "MirrorTestClass", code);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        MirrorTests.assertTrue((String)"Processor was not run", (boolean)ProcessorTestStatus.processorRan());
        MirrorTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testTypeParmaterAPI() throws Exception {
        String projName = MirrorTests.class.getName() + "TypeParameter.Project";
        IPath projectPath = env.addProject(projName, CompilerOptions.getFirstSupportedJavaVersion());
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        TestUtil.createAndAddAnnotationJar(env.getJavaProject(projectPath));
        IProject project = env.getProject(projName);
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        String a1Code = "package pkg;\nimport org.eclipse.jdt.apt.tests.annotations.apitest.Common;\nimport java.lang.annotation.Annotation;\n@Common\npublic class A1<T> {\n    @Common\n   <A extends Annotation> A get(A a){ return a;}\n}\n";
        IPath a1Path = env.addClass(srcRoot, "pkg", "A1", a1Code);
        IJavaProject jproj = env.getJavaProject(projName);
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)true);
        this.fullBuild(project.getFullPath());
        this.expectingNoMarkers();
        this.expectingSpecificProblemsFor(a1Path, new ExpectedProblem[]{new ExpectedProblem("", "Type parameter 'T' belongs to org.eclipse.jdt.apt.core.internal.declaration.ClassDeclarationImpl A1", a1Path), new ExpectedProblem("", "Type parameter 'A' belongs to org.eclipse.jdt.apt.core.internal.declaration.MethodDeclarationImpl get", a1Path)});
    }
}

