/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.apt.core.internal.util.FactoryPathUtil;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.core.IJavaProject;

public class MixedModeTesting
extends APTTestBase {
    private File _extJar;

    public MixedModeTesting(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(MixedModeTesting.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        IJavaProject javaProj = env.getJavaProject(this.getProjectName());
        this._extJar = TestUtil.createAndAddExternalAnnotationJar(javaProj);
        FactoryPath fp = (FactoryPath)AptConfig.getFactoryPath((IJavaProject)javaProj);
        FactoryContainer fc = FactoryPathUtil.newExtJarFactoryContainer((File)this._extJar);
        fp.addEntryToHead(fc, true, true);
        AptConfig.setFactoryPath((IJavaProject)javaProj, (IFactoryPath)fp);
    }

    public void testSimpleBatchProcessing() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String codeA = "package p1;\n\n import org.eclipse.jdt.apt.tests.external.annotations.batch.*;\n@Batch\npublic class A {}\n";
        env.addClass(srcRoot, "p1", "A", codeA);
        String codeB = "package p1;\n\n@Deprecated\npublic class B {}\n";
        env.addClass(srcRoot, "p1", "B", codeB);
        String codeC = "package p1;\n\n import org.eclipse.jdt.apt.tests.external.annotations.batch.*;\n@Batch\npublic class C {}\n";
        env.addClass(srcRoot, "p1", "C", codeC);
        String codeD = "package p1; public class D{}";
        env.addClass(srcRoot, "p1", "D", codeD);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        this.expectingMarkers(new String[]{"CompletedSuccessfully"});
    }

    public void testAPTRoundingInMixedMode0() {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String codeX = "package p1;\n\n import org.eclipse.jdt.apt.tests.annotations.aptrounding.*;\n@GenBean\npublic class X {}\n";
        env.addClass(srcRoot, "p1", "X", codeX);
        String codeY = "package p1;\n\n import org.eclipse.jdt.apt.tests.annotations.aptrounding.*;public class Y { @GenBean2 test.Bean _bean = null; }\n";
        env.addClass(srcRoot, "p1", "Y", codeY);
        String codeA = "package p1;\n\n import org.eclipse.jdt.apt.tests.external.annotations.batch.*;\n@Batch\npublic class A {}\n";
        env.addClass(srcRoot, "p1", "A", codeA);
        String codeB = "package p1;\n\n@Deprecated\npublic class B {}\n";
        env.addClass(srcRoot, "p1", "B", codeB);
        String codeC = "package p1;\n\n import org.eclipse.jdt.apt.tests.external.annotations.batch.*;\n@Batch\npublic class C {}\n";
        env.addClass(srcRoot, "p1", "C", codeC);
        String codeD = "package p1; public class D{}";
        env.addClass(srcRoot, "p1", "D", codeD);
        this.fullBuild(project.getFullPath());
        this.expectingMarkers(new String[]{"CompletedSuccessfully", "Called 2 times."});
        this.expectingNoProblems();
        this.fullBuild(project.getFullPath());
        this.expectingMarkers(new String[]{"CompletedSuccessfully", "Called 2 times."});
        this.expectingNoProblems();
    }

    public void testAPTRoundingInMixedMode1() {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String codeA = "package p1;\n\n import org.eclipse.jdt.apt.tests.external.annotations.batch.*;\n import gen.*;\n@BatchGen\npublic class A {   Class0 clazz0;\n   Class1 clazz1;\n}\n";
        env.addClass(srcRoot, "p1", "A", codeA);
        String codeB = "package p1;\npublic class X {}\n";
        env.addClass(srcRoot, "p1", "X", codeB);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        this.expectingMarkers(new String[]{"Called the third time.", "Called the third time."});
    }
}

