/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.zip.ZipInputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class PerfTests
extends BuilderTests {
    private static final String GITHUB_TESTS_BINARIES = "https://github.com/eclipse-jdt/eclipse.jdt.core.binaries/raw/master/org.eclipse.jdt.core.tests.binaries/";
    private IPath projectPath;

    public PerfTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(PerfTests.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        IWorkspace ws = env.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IPath path = root.getLocation();
        File destRoot = path.toFile();
        File tempPath = PerfTests.fetchFromBinariesProject("perf-test-project.zip", 3307492L);
        FileInputStream in = new FileInputStream(tempPath);
        Throwable throwable = null;
        Object var8_9 = null;
        try (ZipInputStream zipIn = new ZipInputStream(in);){
            TestUtil.unzip(zipIn, destRoot);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.projectPath = env.addProject("org.eclipse.jdt.core", CompilerOptions.getFirstSupportedJavaVersion());
        System.out.println("Performing full build...");
        this.fullBuild(this.projectPath);
        System.out.println("Completed build.");
        this.assertNoUnexpectedProblems();
    }

    private static File fetchFromBinariesProject(String nameInProject, long size) throws IOException, MalformedURLException {
        String tmpRoot = System.getProperty("java.io.tmpdir");
        File tempFile = new File(tmpRoot, nameInProject);
        if (!tempFile.isFile() || tempFile.length() != size) {
            String githubUrl = GITHUB_TESTS_BINARIES + nameInProject;
            Throwable throwable = null;
            Object var7_7 = null;
            try (BufferedInputStream bin = new BufferedInputStream(URI.create(githubUrl).toURL().openStream());){
                Files.copy(bin, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return tempFile;
    }

    private void assertNoUnexpectedProblems() {
        Problem[] problems;
        Problem[] problemArray = problems = env.getProblems();
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (!(problem.getMessage().startsWith("TODO") || problem.getMessage().startsWith("XXX") || problem.getMessage().startsWith("FIXME") || problem.getMessage().equals("The type IWorkingCopy is deprecated"))) {
                PerfTests.fail((String)("Found unexpected problem: " + String.valueOf(problem)));
            }
            ++n2;
        }
    }

    public static String getProjectName() {
        return PerfTests.class.getName() + "Project";
    }

    public IPath getSourcePath() {
        IProject project = env.getProject(PerfTests.getProjectName());
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        return srcRoot;
    }

    public void testBuilding() throws Throwable {
        IProject proj = env.getProject(this.projectPath);
        IJavaProject jproj = JavaCore.create((IProject)proj);
        this.assertNoUnexpectedProblems();
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)false);
        proj.build(15, null);
        this.assertNoUnexpectedProblems();
        System.out.println("Performing full build without apt...");
        long startNanos = System.nanoTime();
        proj.build(6, null);
        long totalWithoutAPT = (System.nanoTime() - startNanos) / 1000000L;
        System.out.println("Completed full build without APT in " + totalWithoutAPT + "ms.");
        this.assertNoUnexpectedProblems();
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)true);
        proj.build(15, null);
        this.assertNoUnexpectedProblems();
        System.out.println("Performing full build with apt...");
        startNanos = System.nanoTime();
        proj.build(6, null);
        long totalWithAPT = (System.nanoTime() - startNanos) / 1000000L;
        System.out.println("Completed full build with APT in " + totalWithAPT + "ms.");
        this.assertNoUnexpectedProblems();
        if ((double)totalWithAPT > (double)totalWithoutAPT * 1.15) {
            PerfTests.fail((String)"APT performance degradation greater than 15%");
        }
    }
}

