/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.File;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.tests.ReadAnnotationTests;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.apt.tests.plugin.AptTestsPlugin;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class ReadAnnotationTests2
extends BuilderTests {
    private final String[] NO_ANNOTATIONS = new String[0];
    private final ICompilationUnit[] NO_UNIT = new ICompilationUnit[0];
    private int counter = 0;
    private String projectName = null;

    public ReadAnnotationTests2(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ReadAnnotationTests2.class);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getUniqueProjectName() {
        this.projectName = ReadAnnotationTests.class.getName() + "Project" + this.counter;
        ++this.counter;
        return this.projectName;
    }

    public IPath getSourcePath() {
        IProject project = env.getProject(this.getProjectName());
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        return srcRoot;
    }

    public IPath getBinaryPath() {
        IProject project = env.getProject(this.getProjectName());
        IFolder srcFolder = project.getFolder("binary");
        IPath lib = srcFolder.getFullPath();
        return lib;
    }

    public IPath getOutputPath() {
        IProject project = env.getProject(this.getProjectName());
        IFolder binFolder = project.getFolder("bin");
        IPath bin = binFolder.getFullPath();
        return bin;
    }

    private void addAllSources() {
        IPath srcRoot = this.getSourcePath();
        env.addClass(srcRoot, "question", "SimpleAnnotation", "package question; \n\nimport java.lang.annotation.Retention; \nimport java.lang.annotation.RetentionPolicy; \n\n@Retention(value=RetentionPolicy.RUNTIME) \npublic @interface SimpleAnnotation { \n\n\tString value(); \n}");
        env.addClass(srcRoot, "question", "RTVisibleAnno", "package question; \n\nimport java.lang.annotation.*; \n\n@Retention(value=RetentionPolicy.RUNTIME) \npublic @interface RTVisibleAnno  \n{\t\n\tString name() default \"eclipse\"; \n\tboolean boolValue() default true; \n\tbyte byteValue() default 0x0001; \n\tchar charValue() default 'e'; \n\tdouble doubleValue() default 0.0; \n\tfloat floatValue()  default 0; \n\tint intValue() default 17; \n\tlong longValue() default 43; \n\tshort shortValue() default 1; \n\tColor[] colors() default {Color.RED, Color.WHITE, Color.BLUE}; \n\tSimpleAnnotation anno(); \n\tSimpleAnnotation[] simpleAnnos() default { @SimpleAnnotation(\"org.eclipse.org\") }; \n\tClass<?>[] clazzes(); \n\tClass<?> clazz() default java.lang.String.class; \n\n }");
        env.addClass(srcRoot, "question", "RTInvisibleAnno", "package question;  \n\n   public @interface RTInvisibleAnno{  \n   \tString value(); \n   }");
        env.addClass(srcRoot, "question", "package-info", "@Deprecated package question; ");
        env.addClass(srcRoot, "question", "Color", "package question;\n\npublic enum Color { RED, WHITE, BLUE; } ");
        env.addClass(srcRoot, "question", "AnnotationTest", "package question;\n\n@Deprecated\n@RTVisibleAnno(anno=@SimpleAnnotation(\"test\"), clazzes={})\n@RTInvisibleAnno(\"question\")\npublic interface AnnotationTest{\n\n    @RTVisibleAnno(name = \"Foundation\",\n                   boolValue   = false, \n                   byteValue   = 0x10,  \n                   charValue   = 'c', \n                   doubleValue = 99.0, \n                   floatValue  = (float)9.0, \n                   intValue    = 999, \n                   longValue = 3333,  \n                   shortValue = 3,    \n                   colors ={ Color.RED, Color.BLUE }, \n                   anno = @SimpleAnnotation(\"core\"),\n                   simpleAnnos = {@SimpleAnnotation(\"org\"),    \n              \t                   @SimpleAnnotation(\"eclipse\"),\n        \t\t                   @SimpleAnnotation(\"jdt\") },  \n                   clazzes = {Object.class, String.class},\n \t\t            clazz = Object.class)\n     @RTInvisibleAnno(\"org.eclipse.jdt.core\")\n     @Deprecated \n     public int field0 = 0; \n\n    @Deprecated \n    public int field1 = 1; \n\n    @RTVisibleAnno(anno=@SimpleAnnotation(\"field\"), clazzes={})\n     @RTInvisibleAnno(\"2\") \n     public int field2 = 2; \n\n    @RTInvisibleAnno(\"3\") \n    public int field3 = 3; \n\n    @SimpleAnnotation(\"4\") \n    public int field4 = 4; \n\n    @RTVisibleAnno(anno=@SimpleAnnotation(\"method0\"), clazzes={}) \n    @RTInvisibleAnno(\"0\") \n    @Deprecated \n     public int method0();  \n \n    @Deprecated \n     public int method1(); \n \n    @RTVisibleAnno(anno=@SimpleAnnotation(\"method2\"), clazzes={}) \n     @RTInvisibleAnno(\"2\") \n    public int method2(); \n\n   @RTInvisibleAnno(\"3\") \n   public int method3(); \n\n   @SimpleAnnotation(\"method4\") \n   public int method4(); \n\n   public int method5(int p0, \n   \t\t\t\t   @Deprecated  \n   \t\t\t\t   int p1, \n   \t\t\t\t   @RTVisibleAnno(anno=@SimpleAnnotation(\"param2\"), clazzes={}) \n   \t\t\t\t   @RTInvisibleAnno(\"2\") \n   \t\t\t\t   int p2); \n\n   public int method6(int p0, int p1, int p2); \n\n   @RTVisibleAnno(name = \"I'm \\\"special\\\": \\t\\\\\\n\",\n\t\t          charValue = '\\'',\n\t\t          clazzes = {},\n\t\t          anno = @SimpleAnnotation(\"\"))\n   public int method7();\n }");
    }

    private IProject setupTest() throws Exception {
        IPath projectPath = env.addProject(this.getUniqueProjectName(), CompilerOptions.getFirstSupportedJavaVersion());
        env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        IJavaProject jproj = env.getJavaProject(projectPath);
        jproj.setOption("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        return env.getProject(this.getProjectName());
    }

    public void testSourceAnnotation() throws Exception {
        IProject project = this.setupTest();
        this.addAllSources();
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        this._testAnnotations();
    }

    public void testBinaryAnnotation() throws Exception {
        IProject project = this.setupTest();
        File jar = TestUtil.getFileInPlugin(AptTestsPlugin.getDefault(), (IPath)new Path("/resources/question.jar"));
        String path = jar.getAbsolutePath();
        env.addExternalJar(project.getFullPath(), path);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        this._testAnnotations();
    }

    private ITypeBinding getTypeBinding(String key, IJavaProject javaProj) {
        class BindingRequestor
        extends ASTRequestor {
            private ITypeBinding _result = null;

            BindingRequestor() {
            }

            public void acceptBinding(String bindingKey, IBinding binding) {
                if (binding != null && binding.getKind() == 2) {
                    this._result = (ITypeBinding)binding;
                }
            }
        }
        BindingRequestor requestor = new BindingRequestor();
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        parser.setResolveBindings(true);
        parser.setProject(javaProj);
        parser.setIgnoreMethodBodies(true);
        parser.createASTs(this.NO_UNIT, new String[]{key}, (ASTRequestor)requestor, null);
        return requestor._result;
    }

    public void _testAnnotations() {
        String typeKey = BindingKey.createTypeBindingKey((String)"question.AnnotationTest");
        ITypeBinding typeBinding = this.getTypeBinding(typeKey, env.getJavaProject(this.getProjectName()));
        ReadAnnotationTests2.assertNotNull((String)"failed to locate 'question.AnnotationTest'", (Object)typeBinding);
        ReadAnnotationTests2.assertEquals((String)"Type name mismatch", (String)"question.AnnotationTest", (String)typeBinding.getQualifiedName());
        String[] expectedPkgAnnos = new String[]{"@Deprecated()"};
        this.assertAnnotation(expectedPkgAnnos, typeBinding.getPackage().getAnnotations());
        String[] expectedTypeAnnos = new String[]{"@Deprecated()", "@RTVisibleAnno(anno = @SimpleAnnotation(value = test), clazzes = {})", "@RTInvisibleAnno(value = question)"};
        this.assertAnnotation(expectedTypeAnnos, typeBinding.getAnnotations());
        IVariableBinding[] fieldBindings = typeBinding.getDeclaredFields();
        int counter = 0;
        ReadAnnotationTests2.assertEquals((int)5, (int)fieldBindings.length);
        IVariableBinding[] iVariableBindingArray = fieldBindings;
        int n = fieldBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding fieldDecl = iVariableBindingArray[n2];
            String name = "field" + counter;
            ReadAnnotationTests2.assertEquals((String)"field name mismatch", (String)name, (String)fieldDecl.getName());
            this.assertAnnotation(switch (counter) {
                case 0 -> new String[]{"@RTVisibleAnno(name = Foundation, boolValue = false, byteValue = 16, charValue = c, doubleValue = 99.0, floatValue = 9.0, intValue = 999, longValue = 3333, shortValue = 3, colors = {question.Color RED, question.Color BLUE}, anno = @SimpleAnnotation(value = core), simpleAnnos = {@SimpleAnnotation(value = org), @SimpleAnnotation(value = eclipse), @SimpleAnnotation(value = jdt)}, clazzes = {Object.class, String.class}, clazz = Object.class)", "@RTInvisibleAnno(value = org.eclipse.jdt.core)", "@Deprecated()"};
                case 1 -> new String[]{"@Deprecated()"};
                case 2 -> new String[]{"@RTVisibleAnno(anno = @SimpleAnnotation(value = field), clazzes = {})", "@RTInvisibleAnno(value = 2)"};
                case 3 -> new String[]{"@RTInvisibleAnno(value = 3)"};
                case 4 -> new String[]{"@SimpleAnnotation(value = 4)"};
                default -> this.NO_ANNOTATIONS;
            }, fieldDecl.getAnnotations());
            ++counter;
            ++n2;
        }
        IMethodBinding[] methodBindings = typeBinding.getDeclaredMethods();
        counter = 0;
        ReadAnnotationTests2.assertEquals((int)7, (int)methodBindings.length);
        IMethodBinding[] iMethodBindingArray = methodBindings;
        int n3 = methodBindings.length;
        n = 0;
        while (n < n3) {
            IMethodBinding methodDecl = iMethodBindingArray[n];
            String name = "method" + counter;
            ReadAnnotationTests2.assertEquals((String)"method name mismatch", (String)name, (String)methodDecl.getName());
            this.assertAnnotation(switch (counter) {
                case 0 -> new String[]{"@RTVisibleAnno(anno = @SimpleAnnotation(value = method0), clazzes = {})", "@RTInvisibleAnno(value = 0)", "@Deprecated()"};
                case 1 -> new String[]{"@Deprecated()"};
                case 2 -> new String[]{"@RTVisibleAnno(anno = @SimpleAnnotation(value = method2), clazzes = {})", "@RTInvisibleAnno(value = 2)"};
                case 3 -> new String[]{"@RTInvisibleAnno(value = 3)"};
                case 4 -> new String[]{"@SimpleAnnotation(value = method4)"};
                default -> this.NO_ANNOTATIONS;
            }, methodDecl.getAnnotations());
            if (counter == 5) {
                int numParameters = methodDecl.getParameterTypes().length;
                int pCounter = 0;
                while (pCounter < numParameters) {
                    this.assertAnnotation(switch (pCounter) {
                        case 1 -> new String[]{"@Deprecated()"};
                        case 2 -> new String[]{"@RTVisibleAnno(anno = @SimpleAnnotation(value = param2), clazzes = {})", "@RTInvisibleAnno(value = 2)"};
                        default -> this.NO_ANNOTATIONS;
                    }, methodDecl.getParameterAnnotations(pCounter));
                    ++pCounter;
                }
            }
            ++counter;
            ++n;
        }
    }

    private void assertAnnotation(String[] expected, IAnnotationBinding[] annotations) {
        int expectedLen = expected.length;
        ReadAnnotationTests2.assertEquals((String)"annotation number mismatch", (int)expected.length, (int)annotations.length);
        HashSet<String> expectedSet = new HashSet<String>(expectedLen * 4 / 3 + 1);
        int i = 0;
        while (i < expectedLen) {
            expectedSet.add(expected[i]);
            ++i;
        }
        int counter = 0;
        IAnnotationBinding[] iAnnotationBindingArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding mirror = iAnnotationBindingArray[n2];
            if (counter >= expectedLen) {
                ReadAnnotationTests2.assertEquals((String)"", (String)mirror.toString());
            } else {
                String mirrorToString = mirror.toString();
                boolean contains = expectedSet.contains(mirrorToString);
                if (!contains) {
                    System.err.println(mirrorToString);
                    System.err.println(expectedSet);
                }
                ReadAnnotationTests2.assertTrue((String)("unexpected annotation " + mirrorToString), (boolean)contains);
                expectedSet.remove(mirrorToString);
            }
            ++counter;
            ++n2;
        }
    }
}

