/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.ExpectedProblem;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class RegressionTests
extends APTTestBase {
    public RegressionTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(RegressionTests.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testBugzilla104032() throws Exception {
        String projName = RegressionTests.class.getName() + "104032.Project";
        IPath projectPath = env.addProject(projName, CompilerOptions.getFirstSupportedJavaVersion());
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        TestUtil.createAndAddAnnotationJar(env.getJavaProject(projectPath));
        IProject project = env.getProject(projName);
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        String a1Code = "package p1; \nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\n@HelloWorldAnnotation\npublic class A1 {}";
        String a2Code = "package p1; \nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\n@HelloWorldAnnotation\npublic class A2 {}";
        String bCode = "package p1; \npublic class B { generatedfilepackage.GeneratedFileTest gft; }";
        env.addClass(srcRoot, "p1", "A1", a1Code);
        env.addClass(srcRoot, "p1", "A2", a2Code);
        env.addClass(srcRoot, "p1", "B", bCode);
        IJavaProject jproj = env.getJavaProject(projName);
        AptConfig.addProcessorOption((IJavaProject)jproj, (String)"test.104032.a", (String)"foo");
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)true);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        ResourcesPlugin.getWorkspace().delete(new IResource[]{project}, true, null);
    }

    public void testBugzilla106541() throws Exception {
        String projName = RegressionTests.class.getName() + "104032.Project";
        IPath projectPath = env.addProject(projName, CompilerOptions.getFirstSupportedJavaVersion());
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IJavaProject javaProject = env.getJavaProject(projectPath);
        AptConfig.setEnabled((IJavaProject)javaProject, (boolean)true);
        TestUtil.createAndAddAnnotationJar(javaProject);
        IProject project = env.getProject(projName);
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        String code = "package p1; \nimport org.eclipse.jdt.apt.tests.annotations.readAnnotationType.SimpleAnnotation;\n@SimpleAnnotation(SimpleAnnotation.Name.HELLO)\npublic class MyClass { \n public test.HELLOGen _gen; }";
        env.addClass(srcRoot, "p1", "MyClass", code);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        Util.delete((IResource)project);
    }

    public void testBugzilla120255() throws Exception {
        String projName = RegressionTests.class.getName() + "120255.Project";
        IPath projectPath = env.addProject(projName, CompilerOptions.getFirstSupportedJavaVersion());
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        TestUtil.createAndAddAnnotationJar(env.getJavaProject(projectPath));
        IProject project = env.getProject(projName);
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        String a1Code = "package pkg; \nimport org.eclipse.jdt.apt.tests.annotations.apitest.Common;\nimport java.util.*;\n\n@Common\npublic class A1<T> {\n     @Common\n    Collection<String> collectionOfString;\n\n    @Common\n    Collection<List> collectionOfList;\n    public static class inner{}}";
        IPath a1Path = env.addClass(srcRoot, "pkg", "A1", a1Code);
        IJavaProject jproj = env.getJavaProject(projName);
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)true);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(a1Path, new ExpectedProblem[]{new ExpectedProblem("", "java.util.List is assignable to java.util.Collection", a1Path), new ExpectedProblem("", "java.lang.String is not assignable to java.util.Collection", a1Path), new ExpectedProblem("", "Type parameter 'T' belongs to org.eclipse.jdt.apt.core.internal.declaration.ClassDeclarationImpl A1", a1Path)});
    }

    public void testBugzilla206591A() throws Exception {
        String projName = RegressionTests.class.getName() + "206591.Project";
        IPath projectPath = env.addProject(projName, CompilerOptions.getFirstSupportedJavaVersion());
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        TestUtil.createAndAddAnnotationJar(env.getJavaProject(projectPath));
        IProject project = env.getProject(projName);
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        String a1Code = "package pkg; \nimport org.eclipse.jdt.apt.tests.annotations.apitest.SubtypeOf;\npublic interface A1 {\n }\nclass A2 implements A1 {\n}\nclass A3 extends A2 {\n    @SubtypeOf(A1.class) // yes\n    A2 _foo;\n    @SubtypeOf(A1.class) // yes\n    A3 _bar;\n    @SubtypeOf(A2.class) // yes\n    A3 _baz;\n    @SubtypeOf(A1.class) // yes\n    A1 _quux;\n    @SubtypeOf(A2.class) // no\n    A1 _yuzz;\n    @SubtypeOf(String.class) // no\n    A2 _wum;\n}\nclass A4 extends A2 implements A1 {\n    @SubtypeOf(A1.class) // yes\n    A4 _humpf;\n    @SubtypeOf(A2.class) // yes\n    A4 _fuddle;\n    @SubtypeOf(A5.class) // no\n    A4 _snee;\n}\nclass A5 {\n}\n";
        IPath a1Path = env.addClass(srcRoot, "pkg", "A1", a1Code);
        IJavaProject jproj = env.getJavaProject(projName);
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)true);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(a1Path, new ExpectedProblem[]{new ExpectedProblem("", "pkg.A2 is a subtype of pkg.A1", a1Path), new ExpectedProblem("", "pkg.A3 is a subtype of pkg.A1", a1Path), new ExpectedProblem("", "pkg.A3 is a subtype of pkg.A2", a1Path), new ExpectedProblem("", "pkg.A1 is a subtype of pkg.A1", a1Path), new ExpectedProblem("", "pkg.A1 is not a subtype of pkg.A2", a1Path), new ExpectedProblem("", "pkg.A2 is not a subtype of java.lang.String", a1Path), new ExpectedProblem("", "pkg.A4 is a subtype of pkg.A1", a1Path), new ExpectedProblem("", "pkg.A4 is a subtype of pkg.A2", a1Path), new ExpectedProblem("", "pkg.A4 is not a subtype of pkg.A5", a1Path)});
    }

    public void testBugzilla206591B() throws Exception {
        String projName = RegressionTests.class.getName() + "206591.Project";
        IPath projectPath = env.addProject(projName, CompilerOptions.getFirstSupportedJavaVersion());
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        TestUtil.createAndAddAnnotationJar(env.getJavaProject(projectPath));
        IProject project = env.getProject(projName);
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        String a1Code = "package pkg; \nimport org.eclipse.jdt.apt.tests.annotations.apitest.AssignableTo;\npublic interface A1 {\n }\nclass A2 implements A1 {\n}\nclass A3 extends A2 {\n    @AssignableTo(A1.class) // yes\n    A2 _foo;\n    @AssignableTo(int.class) // yes\n    byte _bar;\n    @AssignableTo(A1.class) // yes\n    A3 _baz;\n    @AssignableTo(A2.class) // no\n    A1 _quux;\n}";
        IPath a1Path = env.addClass(srcRoot, "pkg", "A1", a1Code);
        IJavaProject jproj = env.getJavaProject(projName);
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)true);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(a1Path, new ExpectedProblem[]{new ExpectedProblem("", "pkg.A2 is assignable to pkg.A1", a1Path), new ExpectedProblem("", "byte is assignable to int", a1Path), new ExpectedProblem("", "pkg.A3 is assignable to pkg.A1", a1Path), new ExpectedProblem("", "pkg.A1 is not assignable to pkg.A2", a1Path)});
    }

    public void testBugzilla423254() throws Exception {
        String projName = RegressionTests.class.getName() + "423254.Project";
        IPath projectPath = env.addProject(projName, CompilerOptions.getFirstSupportedJavaVersion());
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IJavaProject jproj = env.getJavaProject(projName);
        RegressionTests.assertFalse((boolean)AptConfig.hasProjectSpecificFactoryPath((IJavaProject)jproj));
        IFactoryPath fp = AptConfig.getFactoryPath((IJavaProject)jproj);
        fp.addVarJar(Path.fromOSString((String)"/some_phony.jar"));
        AptConfig.setFactoryPath((IJavaProject)jproj, (IFactoryPath)fp);
        RegressionTests.assertTrue((boolean)AptConfig.hasProjectSpecificFactoryPath((IJavaProject)jproj));
        fp = AptConfig.getFactoryPath((IJavaProject)jproj);
        fp.removeVarJar(Path.fromOSString((String)"/some_phony.jar"));
        AptConfig.setFactoryPath((IJavaProject)jproj, (IFactoryPath)fp);
        RegressionTests.assertFalse((boolean)AptConfig.hasProjectSpecificFactoryPath((IJavaProject)jproj));
    }
}

