/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.internal.util.ScannerUtil;
import org.eclipse.jdt.apt.tests.APTTestBase;

public class ScannerTests
extends APTTestBase {
    private final String P = File.separator;

    public ScannerTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ScannerTests.class);
    }

    public void testHasAnnotation() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String code = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.noop.NoOpAnnotation;\n@NoOpAnnotation\npublic class Has\n{\n}";
        env.addClass(srcRoot, "test", "Has", code);
        IFile file = project.getFile(this.P + "src" + this.P + "test" + this.P + "Has.java");
        ScannerTests.assertTrue((String)"Expected annotation instance", (boolean)ScannerUtil.hasAnnotationInstance((IFile)file));
        ScannerTests.assertTrue((String)"Expected annotation instance", (boolean)ScannerUtil.hasAnnotationInstance((char[])code.toCharArray()));
    }

    public void testHasNoAnnotation() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String code = "package test;\npublic class No\n{\n}";
        env.addClass(srcRoot, "test", "No", code);
        IFile file = project.getFile(this.P + "src" + this.P + "test" + this.P + "No.java");
        ScannerTests.assertFalse((String)"Expected no annotation instance", (boolean)ScannerUtil.hasAnnotationInstance((IFile)file));
        ScannerTests.assertFalse((String)"Expected no annotation instance", (boolean)ScannerUtil.hasAnnotationInstance((char[])code.toCharArray()));
    }

    public void testHasAnnotationInComment() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String code = "package test;\n/**\n * @author Joe Bob\n */\npublic class Comments\n{\n    // @Foo\n    /* @Bar */\n}";
        env.addClass(srcRoot, "test", "Comments", code);
        IFile file = project.getFile(this.P + "src" + this.P + "test" + this.P + "Comments.java");
        ScannerTests.assertFalse((String)"Expected no annotation instance", (boolean)ScannerUtil.hasAnnotationInstance((IFile)file));
        ScannerTests.assertFalse((String)"Expected no annotation instance", (boolean)ScannerUtil.hasAnnotationInstance((char[])code.toCharArray()));
    }

    public void _testHasAnnotationDeclaration() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String code = "package test;\npublic @interface AnnoDecl\n{\n}";
        env.addClass(srcRoot, "test", "AnnoDecl", code);
        IFile file = project.getFile(this.P + "src" + this.P + "test" + this.P + "AnnoDecl.java");
        ScannerTests.assertFalse((String)"Expected no annotation instance", (boolean)ScannerUtil.hasAnnotationInstance((IFile)file));
        ScannerTests.assertFalse((String)"Expected no annotation instance", (boolean)ScannerUtil.hasAnnotationInstance((char[])code.toCharArray()));
    }
}

