/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.EnumType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.TypeVisitor;
import com.sun.mirror.util.Types;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.annotations.generic.AbstractGenericProcessor;
import org.eclipse.jdt.apt.tests.annotations.generic.GenericFactory;

public class TypeVisitorTests
extends APTTestBase {
    Cases testCaseIdentifier;
    ArrayList<TypeMirror> typesVisited = new ArrayList();
    final String code = "package test;\nimport org.eclipse.jdt.apt.tests.annotations.generic.*;\nimport java.util.List;\n@GenericAnnotation public class Test\n{\n    int j;\n    int k[];\n    List<? extends Number> ln;\n    class C {}\n    class P<T> { }\n    class D implements Runnable { public void run () {} }\n    void m() {}\n    enum E { elephant }\n    @interface B { E e(); }\n    @B(e = E.elephant)\n    String s;\n}";

    public TypeVisitorTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TypeVisitorTests.class);
    }

    public void testPrimitiveTypeVisitor() {
        this.testCaseIdentifier = Cases.PrimitiveType;
        this.runProcessorBasedTest();
    }

    public void testVoidTypeVisitor() {
        this.testCaseIdentifier = Cases.VoidType;
        this.runProcessorBasedTest();
    }

    public void testClassTypeVisitor() {
        this.testCaseIdentifier = Cases.ClassType;
        this.runProcessorBasedTest();
    }

    public void testEnumTypeVisitor() {
        this.testCaseIdentifier = Cases.EnumType;
        this.runProcessorBasedTest();
    }

    public void testInterfaceTypeVisitor() {
        this.testCaseIdentifier = Cases.InterfaceType;
        this.runProcessorBasedTest();
    }

    public void testAnnotationTypeVisitor() {
        this.testCaseIdentifier = Cases.AnnotationType;
        this.runProcessorBasedTest();
    }

    public void testArrayTypeVisitor() {
        this.testCaseIdentifier = Cases.ArrayType;
        this.runProcessorBasedTest();
    }

    public void testTypeVariableVisitor() {
        this.testCaseIdentifier = Cases.TypeVariable;
        this.runProcessorBasedTest();
    }

    public void testWildcardTypeVisitor() {
        this.testCaseIdentifier = Cases.WildcardType;
        this.runProcessorBasedTest();
    }

    void runProcessorBasedTest() {
        TypeVisitorProc p = new TypeVisitorProc();
        GenericFactory.PROCESSOR = p;
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath();
        env.addClass(srcRoot, "test", "Test", "package test;\nimport org.eclipse.jdt.apt.tests.annotations.generic.*;\nimport java.util.List;\n@GenericAnnotation public class Test\n{\n    int j;\n    int k[];\n    List<? extends Number> ln;\n    class C {}\n    class P<T> { }\n    class D implements Runnable { public void run () {} }\n    void m() {}\n    enum E { elephant }\n    @interface B { E e(); }\n    @B(e = E.elephant)\n    String s;\n}");
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        TypeVisitorTests.assertTrue((String)"Processor not invoked", (boolean)p.called);
    }

    void typeVisited(TypeMirror t) {
        this.typesVisited.add(t);
    }

    void initTypeVisitList() {
        if (this.typesVisited.size() > 0) {
            this.typesVisited.clear();
        }
    }

    static enum Cases {
        PrimitiveType,
        VoidType,
        ClassType,
        EnumType,
        InterfaceType,
        AnnotationType,
        ArrayType,
        TypeVariable,
        WildcardType;

    }

    class TypeVisitorImpl
    implements TypeVisitor {
        TypeVisitorImpl() {
        }

        public void visitTypeMirror(TypeMirror t) {
            TypeVisitorTests.fail((String)("Should never visit a TypeMirror, only a subclass: " + String.valueOf(t)));
        }

        public void visitPrimitiveType(PrimitiveType t) {
            TypeVisitorTests.this.typeVisited((TypeMirror)t);
        }

        public void visitVoidType(VoidType t) {
            TypeVisitorTests.this.typeVisited((TypeMirror)t);
        }

        public void visitReferenceType(ReferenceType t) {
            TypeVisitorTests.fail((String)("Should never visit a ReferenceType, only a subclass: " + String.valueOf(t)));
        }

        public void visitDeclaredType(DeclaredType t) {
            TypeVisitorTests.fail((String)("Should never visit a DeclaredType, only a subclass: " + String.valueOf(t)));
        }

        public void visitClassType(ClassType t) {
            TypeVisitorTests.this.typeVisited((TypeMirror)t);
        }

        public void visitEnumType(EnumType t) {
            TypeVisitorTests.this.typeVisited((TypeMirror)t);
        }

        public void visitInterfaceType(InterfaceType t) {
            TypeVisitorTests.this.typeVisited((TypeMirror)t);
        }

        public void visitAnnotationType(AnnotationType t) {
            TypeVisitorTests.this.typeVisited((TypeMirror)t);
        }

        public void visitArrayType(ArrayType t) {
            TypeVisitorTests.this.typeVisited((TypeMirror)t);
        }

        public void visitTypeVariable(TypeVariable t) {
            TypeVisitorTests.this.typeVisited((TypeMirror)t);
        }

        public void visitWildcardType(WildcardType t) {
            TypeVisitorTests.this.typeVisited((TypeMirror)t);
        }
    }

    class TypeVisitorProc
    extends AbstractGenericProcessor {
        boolean called;

        TypeVisitorProc() {
        }

        public void _process() {
            this.called = true;
            TypeVisitorTests.assertTrue((this.decls.size() == 1 ? 1 : 0) != 0);
            TypeVisitorTests.this.initTypeVisitList();
            TypeDeclaration typeDecl = (TypeDeclaration)this.env.getTypeDeclarations().iterator().next();
            Collection nestedTypes = typeDecl.getNestedTypes();
            Collection fieldDecls = typeDecl.getFields();
            ClassDeclaration classDecl = null;
            FieldDeclaration fieldDecl = null;
            PrimitiveType primitiveType = null;
            AnnotationMirror annoMirror = null;
            Types typesUtil = this.env.getTypeUtils();
            switch (TypeVisitorTests.this.testCaseIdentifier) {
                case PrimitiveType: {
                    for (FieldDeclaration tempDecl : fieldDecls) {
                        if (!tempDecl.getSimpleName().equals("j")) continue;
                        fieldDecl = tempDecl;
                    }
                    primitiveType = (PrimitiveType)fieldDecl.getType();
                    primitiveType.accept((TypeVisitor)new TypeVisitorImpl());
                    TypeVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)TypeVisitorTests.this.typesVisited.size());
                    TypeVisitorTests.assertEquals((String)"Expected PrimitiveType visitor", (String)"PrimitiveTypeImpl", (String)TypeVisitorTests.this.typesVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case VoidType: {
                    MethodDeclaration methodDecl = (MethodDeclaration)typeDecl.getMethods().iterator().next();
                    VoidType voidType = (VoidType)methodDecl.getReturnType();
                    voidType.accept((TypeVisitor)new TypeVisitorImpl());
                    TypeVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)TypeVisitorTests.this.typesVisited.size());
                    TypeVisitorTests.assertEquals((String)"Expected VoidType visitor", (String)"VoidTypeImpl", (String)TypeVisitorTests.this.typesVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case ClassType: {
                    for (TypeDeclaration tempDecl : nestedTypes) {
                        if (!tempDecl.getSimpleName().equals("C")) continue;
                        classDecl = (ClassDeclaration)tempDecl;
                    }
                    ClassType classType = classDecl.getSuperclass();
                    classType.accept((TypeVisitor)new TypeVisitorImpl());
                    TypeVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)TypeVisitorTests.this.typesVisited.size());
                    TypeVisitorTests.assertEquals((String)"Expected ClassType visitor", (String)"ClassDeclarationImpl", (String)TypeVisitorTests.this.typesVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case EnumType: {
                    for (FieldDeclaration tempDecl : fieldDecls) {
                        if (!tempDecl.getSimpleName().equals("s")) continue;
                        fieldDecl = tempDecl;
                    }
                    annoMirror = (AnnotationMirror)fieldDecl.getAnnotationMirrors().iterator().next();
                    EnumType enumType = (EnumType)((AnnotationTypeElementDeclaration)annoMirror.getElementValues().keySet().iterator().next()).getReturnType();
                    enumType.accept((TypeVisitor)new TypeVisitorImpl());
                    TypeVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)TypeVisitorTests.this.typesVisited.size());
                    TypeVisitorTests.assertEquals((String)"Expected EnumType visitor", (String)"EnumDeclarationImpl", (String)TypeVisitorTests.this.typesVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case InterfaceType: {
                    for (TypeDeclaration tempDecl : nestedTypes) {
                        if (!tempDecl.getSimpleName().equals("D")) continue;
                        classDecl = (ClassDeclaration)tempDecl;
                    }
                    InterfaceType interfaceType = (InterfaceType)classDecl.getSuperinterfaces().iterator().next();
                    interfaceType.accept((TypeVisitor)new TypeVisitorImpl());
                    TypeVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)TypeVisitorTests.this.typesVisited.size());
                    TypeVisitorTests.assertEquals((String)"Expected InterfaceType visitor", (String)"InterfaceDeclarationImpl", (String)TypeVisitorTests.this.typesVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case AnnotationType: {
                    for (FieldDeclaration tempDecl : fieldDecls) {
                        if (!tempDecl.getSimpleName().equals("s")) continue;
                        fieldDecl = tempDecl;
                    }
                    annoMirror = (AnnotationMirror)fieldDecl.getAnnotationMirrors().iterator().next();
                    AnnotationType annoType = annoMirror.getAnnotationType();
                    annoType.accept((TypeVisitor)new TypeVisitorImpl());
                    TypeVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)TypeVisitorTests.this.typesVisited.size());
                    TypeVisitorTests.assertEquals((String)"Expected AnnotationType visitor", (String)"AnnotationDeclarationImpl", (String)TypeVisitorTests.this.typesVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case ArrayType: {
                    for (FieldDeclaration tempDecl : fieldDecls) {
                        if (!tempDecl.getSimpleName().equals("k")) continue;
                        fieldDecl = tempDecl;
                    }
                    ArrayType arrayType = (ArrayType)fieldDecl.getType();
                    arrayType.accept((TypeVisitor)new TypeVisitorImpl());
                    TypeVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)TypeVisitorTests.this.typesVisited.size());
                    TypeVisitorTests.assertEquals((String)"Expected ArrayType visitor", (String)"ArrayTypeImpl", (String)TypeVisitorTests.this.typesVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case TypeVariable: {
                    for (TypeDeclaration tempDecl : nestedTypes) {
                        if (!tempDecl.getSimpleName().equals("P")) continue;
                        classDecl = (ClassDeclaration)tempDecl;
                    }
                    TypeParameterDeclaration typeParamDecl = (TypeParameterDeclaration)classDecl.getFormalTypeParameters().iterator().next();
                    TypeVariable typeVariable = typesUtil.getTypeVariable(typeParamDecl);
                    typeVariable.accept((TypeVisitor)new TypeVisitorImpl());
                    TypeVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)TypeVisitorTests.this.typesVisited.size());
                    TypeVisitorTests.assertEquals((String)"Expected TypeVariable visitor", (String)"TypeParameterDeclarationImpl", (String)TypeVisitorTests.this.typesVisited.get(0).getClass().getSimpleName());
                    break;
                }
                case WildcardType: {
                    for (FieldDeclaration tempDecl : fieldDecls) {
                        if (!tempDecl.getSimpleName().equals("ln")) continue;
                        fieldDecl = tempDecl;
                    }
                    InterfaceType wildcardList = (InterfaceType)fieldDecl.getType();
                    WildcardType wildcardType = (WildcardType)wildcardList.getActualTypeArguments().iterator().next();
                    wildcardType.accept((TypeVisitor)new TypeVisitorImpl());
                    TypeVisitorTests.assertEquals((String)"Expect one visitor", (int)1, (int)TypeVisitorTests.this.typesVisited.size());
                    TypeVisitorTests.assertEquals((String)"Expected WildcardType visitor", (String)"WildcardTypeImpl", (String)TypeVisitorTests.this.typesVisited.get(0).getClass().getSimpleName());
                }
            }
        }
    }
}

