/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.tests;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.BindingServiceAddon;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.tests.TestUtil;
import org.eclipse.e4.ui.services.ContextServiceAddon;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BindingCreateTest {
    private static final String DEFAULT_SCHEME_ID = "org.eclipse.ui.defaultAcceleratorConfiguration";
    private static final String ID_WINDOW = "org.eclipse.ui.contexts.window";
    private static final String TEST_ID1 = "test.id1";
    private IEclipseContext workbenchContext;
    private EBindingService bs;
    private ParameterizedCommand cmd;
    private TriggerSequence seq;
    private TriggerSequence emptySeq;
    private Map<String, String> emptyAttrs;
    private Map<String, String> schemeOnly;
    private Map<String, String> schemeAndTypeAttrs;

    @BeforeEach
    public void setUp() {
        IEclipseContext globalContext = TestUtil.getGlobalContext();
        this.workbenchContext = globalContext.createChild("workbenchContext");
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.workbenchContext);
        ContextInjectionFactory.make(ContextServiceAddon.class, (IEclipseContext)this.workbenchContext);
        ContextInjectionFactory.make(BindingServiceAddon.class, (IEclipseContext)this.workbenchContext);
        this.setupTestVars();
    }

    public void setupTestVars() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        this.bs = (EBindingService)this.workbenchContext.get(EBindingService.class);
        this.cmd = cs.createCommand(TEST_ID1, null);
        this.emptySeq = this.bs.createSequence("");
        this.seq = this.bs.createSequence("CTRL+5 T");
        this.emptyAttrs = new HashMap<String, String>();
        this.schemeOnly = new HashMap<String, String>();
        this.schemeOnly.put("schemeId", DEFAULT_SCHEME_ID);
        this.schemeAndTypeAttrs = new HashMap<String, String>();
        this.schemeAndTypeAttrs.put("schemeId", DEFAULT_SCHEME_ID);
        this.schemeAndTypeAttrs.put("type", "user");
    }

    @AfterEach
    public void tearDown() {
        this.workbenchContext.dispose();
        this.workbenchContext = null;
    }

    @Test
    public void testNullSequence() {
        Binding b = this.bs.createBinding(null, this.cmd, ID_WINDOW, this.schemeOnly);
        Assertions.assertNull((Object)b);
    }

    @Test
    public void testNullCommand() {
        Binding b = this.bs.createBinding(this.seq, null, ID_WINDOW, this.schemeOnly);
        Assertions.assertNotNull((Object)b);
    }

    @Test
    public void testNullContext() {
        Binding b = this.bs.createBinding(this.seq, this.cmd, null, this.schemeOnly);
        Assertions.assertNull((Object)b);
    }

    @Test
    public void testNoAttrs() {
        Binding b = this.bs.createBinding(this.seq, this.cmd, ID_WINDOW, null);
        Assertions.assertNotNull((Object)b);
        Assertions.assertEquals((Object)this.seq, (Object)b.getTriggerSequence());
        Assertions.assertEquals((Object)this.cmd, (Object)b.getParameterizedCommand());
        Assertions.assertEquals((Object)ID_WINDOW, (Object)b.getContextId());
        Assertions.assertNotNull((Object)b.getSchemeId());
        Assertions.assertEquals((Object)DEFAULT_SCHEME_ID, (Object)b.getSchemeId());
        Assertions.assertNull((Object)b.getLocale());
        Assertions.assertNull((Object)b.getPlatform());
        Assertions.assertEquals((int)0, (int)b.getType());
    }

    @Test
    public void testEmptySequence() {
        Binding b = this.bs.createBinding(this.emptySeq, this.cmd, ID_WINDOW, null);
        Assertions.assertNull((Object)b);
    }

    @Test
    public void testBindingNoScheme() {
        Binding b = this.bs.createBinding(this.seq, this.cmd, ID_WINDOW, this.emptyAttrs);
        Assertions.assertNotNull((Object)b);
        Assertions.assertEquals((Object)this.seq, (Object)b.getTriggerSequence());
        Assertions.assertEquals((Object)this.cmd, (Object)b.getParameterizedCommand());
        Assertions.assertEquals((Object)ID_WINDOW, (Object)b.getContextId());
        Assertions.assertNotNull((Object)b.getSchemeId());
        Assertions.assertEquals((Object)DEFAULT_SCHEME_ID, (Object)b.getSchemeId());
        Assertions.assertNull((Object)b.getLocale());
        Assertions.assertNull((Object)b.getPlatform());
        Assertions.assertEquals((int)0, (int)b.getType());
    }

    @Test
    public void testSchemeonly() {
        Binding b = this.bs.createBinding(this.seq, this.cmd, ID_WINDOW, this.schemeOnly);
        Assertions.assertNotNull((Object)b);
        Assertions.assertEquals((Object)this.seq, (Object)b.getTriggerSequence());
        Assertions.assertEquals((Object)this.cmd, (Object)b.getParameterizedCommand());
        Assertions.assertEquals((Object)ID_WINDOW, (Object)b.getContextId());
        Assertions.assertNotNull((Object)b.getSchemeId());
        Assertions.assertEquals((Object)DEFAULT_SCHEME_ID, (Object)b.getSchemeId());
        Assertions.assertNull((Object)b.getLocale());
        Assertions.assertNull((Object)b.getPlatform());
        Assertions.assertEquals((int)0, (int)b.getType());
    }

    @Test
    public void testSchemeAndTypeAttrs() {
        Binding b = this.bs.createBinding(this.seq, this.cmd, ID_WINDOW, this.schemeAndTypeAttrs);
        Assertions.assertNotNull((Object)b);
        Assertions.assertEquals((Object)this.seq, (Object)b.getTriggerSequence());
        Assertions.assertEquals((Object)this.cmd, (Object)b.getParameterizedCommand());
        Assertions.assertEquals((Object)ID_WINDOW, (Object)b.getContextId());
        Assertions.assertNotNull((Object)b.getSchemeId());
        Assertions.assertEquals((Object)DEFAULT_SCHEME_ID, (Object)b.getSchemeId());
        Assertions.assertNull((Object)b.getLocale());
        Assertions.assertNull((Object)b.getPlatform());
        Assertions.assertEquals((int)1, (int)b.getType());
    }
}

