/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.BindingServiceAddon;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.bindings.tests.TestUtil;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.services.ContextServiceAddon;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BindingLookupTest {
    private static final String ID_DIALOG = "org.eclipse.ui.contexts.dialog";
    private static final String ID_DIALOG_AND_WINDOW = "org.eclipse.ui.contexts.dialogAndWindow";
    private static final String ID_WINDOW = "org.eclipse.ui.contexts.window";
    private static final String ID_TEXT = "org.eclipse.ui.textScope";
    private static final String ID_JAVA = "org.eclipse.jdt.ui.javaScope";
    private static final String ID_JS = "org.eclipse.wst.jsdt.ui.javaScriptScope";
    static final String[] CONTEXTS;
    private static final String TEST_CAT1 = "test.cat1";
    private static final String TEST_ID1 = "test.id1";
    private static final String TEST_ID2 = "test.id2";
    private IEclipseContext workbenchContext;
    private MApplication application;

    static {
        String[] stringArray = new String[18];
        stringArray[0] = ID_DIALOG_AND_WINDOW;
        stringArray[1] = "DAW";
        stringArray[3] = ID_DIALOG;
        stringArray[4] = "Dialog";
        stringArray[5] = ID_DIALOG_AND_WINDOW;
        stringArray[6] = ID_WINDOW;
        stringArray[7] = "Window";
        stringArray[8] = ID_DIALOG_AND_WINDOW;
        stringArray[9] = ID_TEXT;
        stringArray[10] = "Text Scope";
        stringArray[11] = ID_WINDOW;
        stringArray[12] = ID_JAVA;
        stringArray[13] = "Java scope";
        stringArray[14] = ID_TEXT;
        stringArray[15] = ID_JS;
        stringArray[16] = "JavaScript scope";
        stringArray[17] = ID_TEXT;
        CONTEXTS = stringArray;
    }

    private void defineCommands(IEclipseContext context) {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        Category category = cs.defineCategory(TEST_CAT1, "CAT1", null);
        cs.defineCommand(TEST_ID1, "ID1", null, category, null);
        cs.defineCommand(TEST_ID2, "ID2", null, category, null);
    }

    @BeforeEach
    public void setUp() {
        IEclipseContext globalContext = TestUtil.getGlobalContext();
        this.workbenchContext = globalContext.createChild("workbenchContext");
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.workbenchContext);
        ContextInjectionFactory.make(ContextServiceAddon.class, (IEclipseContext)this.workbenchContext);
        ContextInjectionFactory.make(BindingServiceAddon.class, (IEclipseContext)this.workbenchContext);
        this.application = (MApplication)globalContext.get(MApplication.class);
        this.defineCommands(this.workbenchContext);
        this.defineContexts(this.workbenchContext);
        this.defineBindingTables(this.workbenchContext);
    }

    private void defineContexts(IEclipseContext context) {
        ContextManager contextManager = (ContextManager)context.get(ContextManager.class);
        int i = 0;
        while (i < CONTEXTS.length) {
            Context c = contextManager.getContext(CONTEXTS[i]);
            c.define(CONTEXTS[i + 1], null, CONTEXTS[i + 2]);
            i += 3;
        }
        EContextService cs = (EContextService)context.get(EContextService.class);
        cs.activateContext(ID_DIALOG_AND_WINDOW);
    }

    private void defineBindingTables(IEclipseContext context) {
        BindingTableManager btm = (BindingTableManager)context.get(BindingTableManager.class);
        ContextManager cm = (ContextManager)context.get(ContextManager.class);
        btm.addTable(new BindingTable(cm.getContext(ID_DIALOG_AND_WINDOW), this.application));
        btm.addTable(new BindingTable(cm.getContext(ID_WINDOW), this.application));
        btm.addTable(new BindingTable(cm.getContext(ID_DIALOG), this.application));
    }

    @AfterEach
    public void tearDown() {
        this.workbenchContext.dispose();
        this.workbenchContext = null;
    }

    @Test
    public void testFindBinding() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        Binding perfectMatch = bs.getPerfectMatch(seq);
        Assertions.assertEquals((Object)cmd, (Object)perfectMatch.getParameterizedCommand());
        bs.deactivateBinding(db);
        Assertions.assertNull((Object)bs.getPerfectMatch(seq));
        bs.activateBinding(db);
        Assertions.assertEquals((Object)cmd, (Object)bs.getPerfectMatch(seq).getParameterizedCommand());
    }

    @Test
    public void testFindBindingInParent_Bug562263() {
        EContextService es = (EContextService)this.workbenchContext.get(EContextService.class);
        es.deactivateContext(ID_DIALOG_AND_WINDOW);
        es.activateContext(ID_WINDOW);
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        Binding perfectMatch = bs.getPerfectMatch(seq);
        Assertions.assertEquals((Object)cmd, (Object)perfectMatch.getParameterizedCommand());
        bs.deactivateBinding(db);
        Assertions.assertNull((Object)bs.getPerfectMatch(seq));
        bs.activateBinding(db);
        Assertions.assertEquals((Object)cmd, (Object)bs.getPerfectMatch(seq).getParameterizedCommand());
    }

    @Test
    public void testMultipleBindings() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        TriggerSequence seq2 = bs.createSequence("CTRL+2 X");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        db = this.createDefaultBinding(bs, seq2, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        Assertions.assertEquals((Object)cmd, (Object)bs.getPerfectMatch(seq).getParameterizedCommand());
        Assertions.assertEquals((Object)cmd, (Object)bs.getPerfectMatch(seq2).getParameterizedCommand());
    }

    @Test
    public void testLookupChildBinding() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class);
        TriggerSequence seq = bs1.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(bs1, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs1.activateBinding(db);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class);
        Assertions.assertEquals((Object)cmd, (Object)wBS.getPerfectMatch(seq).getParameterizedCommand());
        Assertions.assertEquals((Object)cmd, (Object)bs1.getPerfectMatch(seq).getParameterizedCommand());
        bs1.deactivateBinding(db);
        Assertions.assertNull((Object)wBS.getPerfectMatch(seq));
        Assertions.assertNull((Object)bs1.getPerfectMatch(seq));
    }

    @Test
    public void testLookupWithTwoChildren() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd1 = cs.createCommand(TEST_ID1, null);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq = wBS.createSequence("CTRL+5 T");
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EContextService es = (EContextService)c1.get(EContextService.class);
        es.activateContext(ID_WINDOW);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class);
        Binding db = this.createDefaultBinding(bs1, seq, cmd1, ID_WINDOW);
        bs1.activateBinding(db);
        IEclipseContext c2 = this.workbenchContext.createChild("c2");
        EContextService es2 = (EContextService)c2.get(EContextService.class);
        es2.activateContext(ID_DIALOG);
        EBindingService bs2 = (EBindingService)c2.get(EBindingService.class);
        db = this.createDefaultBinding(bs1, seq, cmd2, ID_DIALOG);
        bs2.activateBinding(db);
        Assertions.assertEquals((Object)cmd1, (Object)wBS.getPerfectMatch(seq).getParameterizedCommand());
        Assertions.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq).getParameterizedCommand());
        Assertions.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq).getParameterizedCommand());
    }

    @Test
    public void testLookupWithDifferentActiveChild() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd1 = cs.createCommand(TEST_ID1, null);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq = wBS.createSequence("CTRL+5 T");
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EContextService es = (EContextService)c1.get(EContextService.class);
        es.activateContext(ID_WINDOW);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class);
        Binding db = this.createDefaultBinding(bs1, seq, cmd1, ID_WINDOW);
        bs1.activateBinding(db);
        IEclipseContext c2 = this.workbenchContext.createChild("c2");
        EContextService es2 = (EContextService)c2.get(EContextService.class);
        es2.activateContext(ID_DIALOG);
        EBindingService bs2 = (EBindingService)c2.get(EBindingService.class);
        db = this.createDefaultBinding(bs1, seq, cmd2, ID_DIALOG);
        bs2.activateBinding(db);
        Assertions.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq).getParameterizedCommand());
        Assertions.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq).getParameterizedCommand());
        Assertions.assertEquals((Object)cmd1, (Object)wBS.getPerfectMatch(seq).getParameterizedCommand());
        c2.activate();
        Assertions.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq).getParameterizedCommand());
        Assertions.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq).getParameterizedCommand());
        Assertions.assertEquals((Object)cmd2, (Object)wBS.getPerfectMatch(seq).getParameterizedCommand());
        c1.activate();
        Assertions.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq).getParameterizedCommand());
        Assertions.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq).getParameterizedCommand());
        Assertions.assertEquals((Object)cmd1, (Object)wBS.getPerfectMatch(seq).getParameterizedCommand());
        c2.activate();
        Assertions.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq).getParameterizedCommand());
        Assertions.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq).getParameterizedCommand());
        Assertions.assertEquals((Object)cmd2, (Object)wBS.getPerfectMatch(seq).getParameterizedCommand());
        Assertions.assertTrue((boolean)wBS.isPerfectMatch(seq));
    }

    @Test
    public void testLookupShortcut() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        Assertions.assertEquals((Object)seq, (Object)bs.getBestSequenceFor(cmd));
    }

    @Test
    public void testLookupShortcuts() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        TriggerSequence seq2 = bs.createSequence("CTRL+2 X");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        Binding db2 = this.createDefaultBinding(bs, seq2, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db2);
        TriggerSequence foundSequence = bs.getBestSequenceFor(cmd);
        Assertions.assertNotNull((Object)foundSequence);
        Assertions.assertEquals((Object)seq, (Object)foundSequence);
    }

    @Test
    public void testLookupBestShortcut() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq2 = bs.createSequence("ALT+5 X");
        Binding db2 = this.createDefaultBinding(bs, seq2, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db2);
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        TriggerSequence foundSequence = bs.getBestSequenceFor(cmd);
        Assertions.assertNotNull((Object)foundSequence);
        Assertions.assertEquals((Object)seq, (Object)foundSequence);
    }

    @Test
    public void testLookupBestShortcutWithChild() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq2 = bs.createSequence("CTRL+5 T");
        Binding db2 = this.createDefaultBinding(bs, seq2, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db2);
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class);
        TriggerSequence seq = bs1.createSequence("ALT+5 X");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs1.activateBinding(db);
        TriggerSequence foundSequence = bs.getBestSequenceFor(cmd);
        Assertions.assertNotNull((Object)foundSequence);
        Assertions.assertEquals((Object)seq2, (Object)foundSequence);
    }

    @Test
    public void testLookupShortcutsTwoChildren() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd1 = cs.createCommand(TEST_ID1, null);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq = wBS.createSequence("CTRL+5 T");
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EContextService es = (EContextService)c1.get(EContextService.class);
        es.activateContext(ID_WINDOW);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class);
        Binding db = this.createDefaultBinding(bs1, seq, cmd1, ID_WINDOW);
        bs1.activateBinding(db);
        IEclipseContext c2 = this.workbenchContext.createChild("c2");
        EContextService es2 = (EContextService)c2.get(EContextService.class);
        es2.activateContext(ID_DIALOG);
        EBindingService bs2 = (EBindingService)c2.get(EBindingService.class);
        Binding db2 = this.createDefaultBinding(bs2, seq, cmd2, ID_DIALOG);
        bs2.activateBinding(db2);
        Assertions.assertEquals((Object)seq, (Object)wBS.getBestSequenceFor(cmd1));
        Assertions.assertNull((Object)wBS.getBestSequenceFor(cmd2));
        Assertions.assertEquals((Object)seq, (Object)bs1.getBestSequenceFor(cmd1));
        Assertions.assertNull((Object)bs1.getBestSequenceFor(cmd2));
        Assertions.assertEquals((Object)seq, (Object)bs2.getBestSequenceFor(cmd2));
        Assertions.assertNull((Object)bs2.getBestSequenceFor(cmd1));
    }

    @Test
    public void testLookupAllShortcuts() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq2 = bs.createSequence("ALT+5 X");
        Binding db2 = this.createDefaultBinding(bs, seq2, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db2);
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        ArrayList<TriggerSequence> list = new ArrayList<TriggerSequence>();
        list.add(seq);
        list.add(seq2);
        Assertions.assertEquals(list, (Object)bs.getSequencesFor(cmd));
    }

    @Test
    public void testLookupAllShortcutsWithChild() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq2 = wBS.createSequence("ALT+5 X");
        Binding db2 = this.createDefaultBinding(wBS, seq2, cmd, ID_DIALOG_AND_WINDOW);
        wBS.activateBinding(db2);
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EContextService es = (EContextService)c1.get(EContextService.class);
        es.activateContext(ID_WINDOW);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class);
        TriggerSequence seq = bs1.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(wBS, seq, cmd, ID_WINDOW);
        bs1.activateBinding(db);
        ArrayList<TriggerSequence> list = new ArrayList<TriggerSequence>();
        list.add(seq);
        list.add(seq2);
        Assertions.assertEquals(list, (Object)wBS.getSequencesFor(cmd));
    }

    @Test
    public void testPartialMatch() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq2 = wBS.createSequence("ALT+5 X");
        Binding db2 = this.createDefaultBinding(wBS, seq2, cmd, ID_DIALOG_AND_WINDOW);
        wBS.activateBinding(db2);
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class);
        TriggerSequence seq = bs1.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(wBS, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs1.activateBinding(db);
        TriggerSequence partialMatch = bs1.createSequence("CTRL+5");
        TriggerSequence partialNoMatch = bs1.createSequence("CTRL+8");
        Assertions.assertFalse((boolean)bs1.isPartialMatch(partialNoMatch));
        Assertions.assertTrue((boolean)bs1.isPartialMatch(partialMatch));
    }

    @Test
    public void testGetPartialMatches() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq2 = wBS.createSequence("ALT+5 X");
        Binding wbBind = this.createDefaultBinding(wBS, seq2, cmd, ID_DIALOG_AND_WINDOW);
        wBS.activateBinding(wbBind);
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class);
        TriggerSequence seq = bs1.createSequence("CTRL+5 T");
        Binding b1 = this.createDefaultBinding(wBS, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs1.activateBinding(b1);
        TriggerSequence sseq = bs1.createSequence("CTRL+5 Y");
        Binding b2 = this.createDefaultBinding(bs1, sseq, cmd2, ID_DIALOG_AND_WINDOW);
        bs1.activateBinding(b2);
        ArrayList<Binding> commandMatches = new ArrayList<Binding>();
        commandMatches.add(b1);
        commandMatches.add(b2);
        TriggerSequence partialMatch = bs1.createSequence("CTRL+5");
        TriggerSequence partialNoMatch = bs1.createSequence("CTRL+8");
        Assertions.assertFalse((boolean)bs1.isPartialMatch(partialNoMatch));
        Assertions.assertTrue((boolean)bs1.isPartialMatch(partialMatch));
        Collection matches = bs1.getPartialMatches(partialMatch);
        Assertions.assertEquals(commandMatches, (Object)matches);
    }

    private Binding createDefaultBinding(EBindingService bs, TriggerSequence sequence, ParameterizedCommand command, String contextId) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("schemeId", "org.eclipse.ui.defaultAcceleratorConfiguration");
        return bs.createBinding(sequence, command, contextId, attrs);
    }
}

