/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.tests;

import java.util.List;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.internal.KeyAssistDialog;
import org.eclipse.e4.ui.bindings.keys.KeyBindingDispatcher;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class KeyAssistDialogTest {
    private final Binding binding1 = this.mockBinding("Command 1");
    private final Binding binding2 = this.mockBinding("Command 2");
    private final Binding binding3 = this.mockBinding("Command 3");

    @Test
    public void testIsShowingBindings() throws Exception {
        KeyAssistDialog keyAssistDialog = new KeyAssistDialog((IEclipseContext)Mockito.mock(IEclipseContext.class), new KeyBindingDispatcher());
        keyAssistDialog.open(List.of(this.binding1, this.binding2));
        Assertions.assertTrue((boolean)keyAssistDialog.isShowingBindings(List.of(this.binding2, this.binding1)));
        Assertions.assertFalse((boolean)keyAssistDialog.isShowingBindings(List.of(this.binding2, this.binding3)));
        keyAssistDialog.close();
        Assertions.assertFalse((boolean)keyAssistDialog.isShowingBindings(List.of(this.binding2, this.binding1)));
    }

    private Binding mockBinding(String commandName) {
        ParameterizedCommand command = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        try {
            Mockito.when((Object)command.getName()).thenReturn((Object)commandName);
        }
        catch (NotDefinedException e) {
            throw new RuntimeException(e);
        }
        Binding binding = (Binding)Mockito.mock(Binding.class);
        Mockito.when((Object)binding.getParameterizedCommand()).thenReturn((Object)command);
        Mockito.when((Object)binding.getTriggerSequence()).thenReturn((Object)KeySequence.getInstance());
        return binding;
    }
}

