/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.javaeditor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.examples.javaeditor.JavaEditorMessages;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class JavaContentOutlinePage
extends ContentOutlinePage {
    protected Object fInput;
    protected IDocumentProvider fDocumentProvider;
    protected ITextEditor fTextEditor;

    public JavaContentOutlinePage(IDocumentProvider provider, ITextEditor editor) {
        this.fDocumentProvider = provider;
        this.fTextEditor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        IStructuredSelection selection = event.getStructuredSelection();
        if (selection.isEmpty()) {
            this.fTextEditor.resetHighlightRange();
        } else {
            Segment segment = (Segment)selection.getFirstElement();
            int start = segment.position.getOffset();
            int length = segment.position.getLength();
            try {
                this.fTextEditor.setHighlightRange(start, length, true);
            }
            catch (IllegalArgumentException x) {
                this.fTextEditor.resetHighlightRange();
            }
        }
    }

    public void setInput(Object input) {
        this.fInput = input;
        this.update();
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput(this.fInput);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        protected static final String SEGMENTS = "__java_segments";
        protected IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("__java_segments");
        protected List<Segment> fContent = new ArrayList<Segment>(10);

        protected ContentProvider() {
        }

        protected void parse(IDocument document) {
            int lines = document.getNumberOfLines();
            int increment = Math.max(lines / 10, 10);
            int line = 0;
            while (line < lines) {
                int length = increment;
                if (line + increment > lines) {
                    length = lines - line;
                }
                try {
                    int offset = document.getLineOffset(line);
                    int end = document.getLineOffset(line + length);
                    length = end - offset;
                    Position p = new Position(offset, length);
                    document.addPosition(SEGMENTS, p);
                    this.fContent.add(new Segment(MessageFormat.format(JavaEditorMessages.getString("OutlinePage.segment.title_pattern"), offset), p));
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                line += increment;
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            IDocument document;
            if (oldInput != null && (document = JavaContentOutlinePage.this.fDocumentProvider.getDocument(oldInput)) != null) {
                try {
                    document.removePositionCategory(SEGMENTS);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                    // empty catch block
                }
                document.removePositionUpdater(this.fPositionUpdater);
            }
            this.fContent.clear();
            if (newInput != null && (document = JavaContentOutlinePage.this.fDocumentProvider.getDocument(newInput)) != null) {
                document.addPositionCategory(SEGMENTS);
                document.addPositionUpdater(this.fPositionUpdater);
                this.parse(document);
            }
        }

        public void dispose() {
            if (this.fContent != null) {
                this.fContent.clear();
                this.fContent = null;
            }
        }

        public Object[] getElements(Object element) {
            return this.fContent.toArray();
        }

        public boolean hasChildren(Object element) {
            return element == JavaContentOutlinePage.this.fInput;
        }

        public Object getParent(Object element) {
            if (element instanceof Segment) {
                return JavaContentOutlinePage.this.fInput;
            }
            return null;
        }

        public Object[] getChildren(Object element) {
            if (element == JavaContentOutlinePage.this.fInput) {
                return this.fContent.toArray();
            }
            return new Object[0];
        }
    }

    protected static class Segment {
        public String name;
        public Position position;

        public Segment(String name, Position position) {
            this.name = name;
            this.position = position;
        }

        public String toString() {
            return this.name;
        }
    }
}

