/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.javaeditor;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class JavaPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String JAVA_MULTILINE_COMMENT = "__java_multiline_comment";
    public static final String JAVA_DOC = "__java_javadoc";
    public static final String[] JAVA_PARTITION_TYPES = new String[]{"__java_multiline_comment", "__java_javadoc"};

    public JavaPartitionScanner() {
        Token javaDoc = new Token((Object)JAVA_DOC);
        Token comment = new Token((Object)JAVA_MULTILINE_COMMENT);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", Token.UNDEFINED));
        rules.add(new SingleLineRule("\"", "\"", Token.UNDEFINED, '\\'));
        rules.add(new SingleLineRule("'", "'", Token.UNDEFINED, '\\'));
        rules.add((Object)new WordPredicateRule((IToken)comment));
        rules.add(new MultiLineRule("/**", "*/", (IToken)javaDoc, '\u0000', true));
        rules.add(new MultiLineRule("/*", "*/", (IToken)comment, '\u0000', true));
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        this.setPredicateRules(result);
    }

    static class EmptyCommentDetector
    implements IWordDetector {
        EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }

    static class WordPredicateRule
    extends WordRule
    implements IPredicateRule {
        private final IToken fSuccessToken;

        public WordPredicateRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.fSuccessToken = successToken;
            this.addWord("/**/", this.fSuccessToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return super.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.fSuccessToken;
        }
    }
}

