/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.javaeditor.java;

import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.ui.examples.javaeditor.util.JavaColorProvider;
import org.eclipse.ui.examples.javaeditor.util.JavaWhitespaceDetector;
import org.eclipse.ui.examples.javaeditor.util.JavaWordDetector;

public class JavaCodeScanner
extends RuleBasedScanner {
    private static String[] fgKeywords = new String[]{"abstract", "break", "case", "catch", "class", "continue", "default", "do", "else", "extends", "final", "finally", "for", "if", "implements", "import", "instanceof", "interface", "native", "new", "package", "private", "protected", "public", "return", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while"};
    private static String[] fgTypes = new String[]{"void", "boolean", "char", "byte", "short", "int", "long", "float", "double"};
    private static String[] fgConstants = new String[]{"false", "null", "true"};

    public JavaCodeScanner(JavaColorProvider provider) {
        Token keyword = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.KEYWORD)));
        Token type = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.TYPE)));
        Token string = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.STRING)));
        Token comment = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.SINGLE_LINE_COMMENT)));
        Token other = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.DEFAULT)));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new JavaWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new JavaWordDetector(), (IToken)other);
        String[] stringArray = fgKeywords;
        int n = fgKeywords.length;
        int n2 = 0;
        while (n2 < n) {
            String fgKeyword = stringArray[n2];
            wordRule.addWord(fgKeyword, (IToken)keyword);
            ++n2;
        }
        stringArray = fgTypes;
        n = fgTypes.length;
        n2 = 0;
        while (n2 < n) {
            String fgType = stringArray[n2];
            wordRule.addWord(fgType, (IToken)type);
            ++n2;
        }
        stringArray = fgConstants;
        n = fgConstants.length;
        n2 = 0;
        while (n2 < n) {
            String fgConstant = stringArray[n2];
            wordRule.addWord(fgConstant, (IToken)type);
            ++n2;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

