/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.javaeditor.java;

import java.text.MessageFormat;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.examples.javaeditor.java.JavaEditorMessages;

public class JavaCompletionProcessor
implements IContentAssistProcessor {
    protected static final String[] fgProposals = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    protected IContextInformationValidator fValidator = new Validator();

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ICompletionProposal[] result = new ICompletionProposal[fgProposals.length];
        int i = 0;
        while (i < fgProposals.length) {
            ContextInformation info = new ContextInformation(fgProposals[i], MessageFormat.format(JavaEditorMessages.getString("CompletionProcessor.Proposal.ContextInfo.pattern"), fgProposals[i]));
            result[i] = new CompletionProposal(fgProposals[i], documentOffset, 0, fgProposals[i].length(), null, fgProposals[i], (IContextInformation)info, MessageFormat.format(JavaEditorMessages.getString("CompletionProcessor.Proposal.hoverinfo.pattern"), fgProposals[i]));
            ++i;
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        IContextInformation[] result = new IContextInformation[5];
        int i = 0;
        while (i < result.length) {
            result[i] = new ContextInformation(MessageFormat.format(JavaEditorMessages.getString("CompletionProcessor.ContextInfo.display.pattern"), i, documentOffset), MessageFormat.format(JavaEditorMessages.getString("CompletionProcessor.ContextInfo.value.pattern"), i, documentOffset - 5, documentOffset + 5));
            ++i;
        }
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.', '('};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'#'};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public String getErrorMessage() {
        return null;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

