/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.javaeditor.javadoc;

import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.ui.examples.javaeditor.util.JavaColorProvider;
import org.eclipse.ui.examples.javaeditor.util.JavaWhitespaceDetector;

public class JavaDocScanner
extends RuleBasedScanner {
    private static String[] fgKeywords = new String[]{"@author", "@deprecated", "@exception", "@param", "@return", "@see", "@serial", "@serialData", "@serialField", "@since", "@throws", "@version"};

    public JavaDocScanner(JavaColorProvider provider) {
        this.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.JAVADOC_DEFAULT))));
        Token keyword = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.JAVADOC_KEYWORD)));
        Token tag = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.JAVADOC_TAG)));
        Token link = new Token((Object)new TextAttribute(provider.getColor(JavaColorProvider.JAVADOC_LINK)));
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new SingleLineRule("<", ">", (IToken)tag));
        list.add(new SingleLineRule("{", "}", (IToken)link));
        list.add(new WhitespaceRule((IWhitespaceDetector)new JavaWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new JavaDocWordDetector());
        String[] stringArray = fgKeywords;
        int n = fgKeywords.length;
        int n2 = 0;
        while (n2 < n) {
            String fgKeyword = stringArray[n2];
            wordRule.addWord(fgKeyword, (IToken)keyword);
            ++n2;
        }
        list.add(wordRule);
        IRule[] result = new IRule[list.size()];
        list.toArray(result);
        this.setRules(result);
    }

    static class JavaDocWordDetector
    implements IWordDetector {
        JavaDocWordDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@';
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c);
        }
    }
}

