/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.structurecreator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class Util {
    private static final String RESOURCE_BUNDLE = "org.eclipse.compare.examples.structurecreator.CompareExampleMessages";
    private static ResourceBundle fgResourceBundle = ResourceBundle.getBundle("org.eclipse.compare.examples.structurecreator.CompareExampleMessages");

    public static String getString(String key) {
        try {
            return fgResourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    private static String readString(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));){
                StringBuilder buffer = new StringBuilder();
                char[] part = new char[2048];
                int read = 0;
                while ((read = reader.read(part)) != -1) {
                    buffer.append(part, 0, read);
                }
                return buffer.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static String readString(IStreamContentAccessor sa) throws CoreException {
        InputStream is = sa.getContents();
        String encoding = null;
        if (sa instanceof IEncodedStreamContentAccessor) {
            encoding = ((IEncodedStreamContentAccessor)sa).getCharset();
        }
        if (encoding == null) {
            encoding = ResourcesPlugin.getEncoding();
        }
        return Util.readString(is, encoding);
    }
}

