/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.TestRegistryChangeListener;
import org.junit.jupiter.api.Assertions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;

public class BundleTestingHelper {
    public static Bundle[] getBundles(BundleContext context, String symbolicName, String version) {
        return Platform.getBundles((String)symbolicName, (String)version);
    }

    @Deprecated
    public static Bundle installBundle(BundleContext context, String location) throws BundleException, MalformedURLException, IOException {
        return BundleTestingHelper.installBundle("", context, location);
    }

    public static Bundle installBundle(String tag, BundleContext context, String location) throws BundleException, MalformedURLException, IOException {
        URL entry = context.getBundle().getEntry(location);
        Assertions.assertNotNull((Object)entry, (String)(tag + " entry " + location + " could not be found in " + context.getBundle().getSymbolicName()));
        return context.installBundle(FileLocator.toFileURL((URL)entry).toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void refreshPackages(BundleContext context, Bundle[] bundles) {
        if (bundles.length == 0) {
            return;
        }
        FrameworkWiring wiring = (FrameworkWiring)context.getBundle("System Bundle").adapt(FrameworkWiring.class);
        boolean[] flag = new boolean[1];
        FrameworkListener listener = event -> {
            if (event.getType() != 4) return;
            boolean[] blArray2 = flag;
            synchronized (flag) {
                blArray[0] = true;
                flag.notifyAll();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        };
        wiring.refreshBundles(Arrays.asList(bundles), new FrameworkListener[]{listener});
        boolean[] blArray = flag;
        synchronized (flag) {
            while (true) {
                if (flag[0]) {
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                try {
                    flag.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean resolveBundles(BundleContext context, Bundle[] bundles) {
        FrameworkWiring wiring = (FrameworkWiring)context.getBundle("System Bundle").adapt(FrameworkWiring.class);
        return wiring.resolveBundles(Arrays.asList(bundles));
    }

    /*
     * Unable to fully structure code
     */
    public static void runWithBundles(Callable<Void> runnable, BundleContext context, String[] locations, TestRegistryChangeListener listener) throws Exception {
        if (listener != null) {
            listener.register();
        }
        try {
            installed = new Bundle[locations.length];
            i = 0;
            while (i < locations.length) {
                installed[i] = BundleTestingHelper.installBundle(context, locations[i]);
                Assertions.assertEquals((int)2, (int)installed[i].getState(), (String)locations[i]);
                ++i;
            }
            if (listener != null) {
                listener.reset();
            }
            Assertions.assertTrue((boolean)BundleTestingHelper.resolveBundles(context, installed));
            if (listener != null) {
                Assertions.assertTrue((boolean)listener.eventReceived(installed.length * 10000));
            }
            try {
                runnable.call();
            }
            finally {
                if (listener != null) {
                    listener.reset();
                }
                var9_8 = installed;
                var8_10 = installed.length;
                var7_12 = 0;
                ** while (var7_12 < var8_10)
            }
lbl-1000:
            // 1 sources

            {
                element = var9_8[var7_12];
                element.uninstall();
                ++var7_12;
                continue;
            }
lbl31:
            // 1 sources

            BundleTestingHelper.resolveBundles(context, installed);
            if (listener != null) {
                Assertions.assertTrue((boolean)listener.eventReceived(installed.length * 10000));
            }
        }
        finally {
            if (listener != null) {
                listener.unregister();
            }
        }
    }
}

