/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.harness.TestHarnessPlugin;
import org.junit.function.ThrowingRunnable;

public class FileSystemHelper {
    protected static int nextLocationCounter = 0;
    private static final long MASK = 0xFFFFFFFFL;
    private static Boolean canCreateSymLinks = null;

    public static IPath getTempDir() {
        String tempPath = System.getProperty("java.io.tmpdir");
        try {
            tempPath = new File(tempPath).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return IPath.fromOSString((String)tempPath);
    }

    public static IPath getRandomLocation() {
        return FileSystemHelper.getRandomLocation(FileSystemHelper.getTempDir());
    }

    public static IPath getRandomLocation(IPath parent) {
        IPath path = FileSystemHelper.computeRandomLocation(parent);
        while (path.toFile().exists()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            path = FileSystemHelper.computeRandomLocation(parent);
        }
        return path;
    }

    public static IPath computeRandomLocation(IPath parent) {
        long segment = (long)(++nextLocationCounter) << 32 | System.currentTimeMillis() & 0xFFFFFFFFL;
        return parent.append(Long.toString(segment));
    }

    public static void clear(File file) {
        String[] files;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.list()) != null) {
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                FileSystemHelper.clear(new File(file, child));
                ++n2;
            }
        }
        if (!file.delete()) {
            String message = "FileSystemHelper#clear() could not delete: " + file.getPath();
            TestHarnessPlugin.log((IStatus)new Status(2, "org.eclipse.core.tests.harness", 0, message, null));
        }
    }

    public static void createSymLink(File basedir, String linkName, String linkTarget, boolean isDir) throws IOException {
        Process process = FileSystemHelper.startSymlinkCreation(basedir, linkName, linkTarget, isDir);
        try {
            int exitcode = process.waitFor();
            if (exitcode != 0) {
                Throwable throwable = null;
                Object var7_9 = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    try {
                        String result = reader.readLine();
                        throw new IllegalStateException("Creating symlink is unsupported: " + result);
                    }
                    catch (Throwable throwable2) {
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Creating symlink failed due to interrupted exception", e);
        }
    }

    private static Process startSymlinkCreation(File basedir, String linkName, String linkTarget, boolean isDir) throws IOException {
        String[] environmentParameters = new String[]{};
        if (Platform.getOS().equals("win32")) {
            return FileSystemHelper.startSymlinkCreationOnWindows(basedir, linkName, linkTarget, isDir, environmentParameters);
        }
        String[] cmd = new String[]{"ln", "-s", linkTarget, linkName};
        return Runtime.getRuntime().exec(cmd, environmentParameters, basedir);
    }

    private static Process startSymlinkCreationOnWindows(File basedir, String linkName, String linkTarget, boolean isDir, String[] environmentParameters) throws IOException {
        if (isDir) {
            String[] cmd = new String[]{"cmd", "/c", "mklink", "/d", new File(linkName).getPath(), new File(linkTarget).getPath()};
            return Runtime.getRuntime().exec(cmd, environmentParameters, basedir);
        }
        String[] cmd = new String[]{"cmd", "/c", "mklink", new File(linkName).getPath(), new File(linkTarget).getPath()};
        return Runtime.getRuntime().exec(cmd, environmentParameters, basedir);
    }

    public static boolean canCreateSymLinks() throws IOException {
        if (canCreateSymLinks == null) {
            if (Platform.getOS().equals("win32")) {
                IPath tempDir = FileSystemHelper.getTempDir();
                String linkName = FileSystemHelper.getRandomLocation(tempDir).lastSegment();
                try {
                    FileSystemHelper.createSymLink(tempDir.toFile(), linkName, "testTarget", false);
                    new File(tempDir.toFile(), linkName).delete();
                    canCreateSymLinks = Boolean.TRUE;
                }
                catch (IllegalStateException e) {
                    canCreateSymLinks = Boolean.FALSE;
                }
            } else {
                canCreateSymLinks = Boolean.TRUE;
            }
        }
        return canCreateSymLinks;
    }

    public static void deleteRecursively(Path path) throws IOException {
        Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(FileSystemHelper::deleteSilently);
    }

    private static void deleteSilently(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException exception) {
            ILog.get().log((IStatus)new Status(2, "org.eclipse.core.tests.harness", "Test file or directory could not be removed: " + String.valueOf(path), (Throwable)exception));
        }
    }

    public static void deleteOnShutdownRecursively(Path path) {
        Runnable deleteDirectory = () -> {
            try {
                FileSystemHelper.deleteRecursively(path);
            }
            catch (IOException exception) {
                ILog.get().log((IStatus)new Status(2, "org.eclipse.core.tests.harness", "Error when removing test directory: " + String.valueOf(path), (Throwable)exception));
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(deleteDirectory));
    }

    public static void deleteAfterExecution(Path pathToDelete, ThrowingRunnable operationToExecute) throws Throwable {
        try {
            operationToExecute.run();
        }
        finally {
            FileSystemHelper.deleteRecursively(pathToDelete);
        }
    }
}

