/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import junit.framework.AssertionFailedError;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.TestProgressMonitor;

public class FussyProgressMonitor
extends TestProgressMonitor {
    private static final double EPS_FACTOR = 0.01;
    private static final long NOTICEABLE_DELAY = 1000L;
    private boolean beginTaskCalled;
    private long beginTime;
    private boolean canceled;
    private int doneCalls;
    private boolean hasFailed;
    private boolean sanityCheckCalled = true;
    private String taskName;
    private int totalWork;
    private double workedSoFar;
    private Job job;

    public FussyProgressMonitor() {
        this.prepare();
    }

    public FussyProgressMonitor(Job job) {
        this();
        this.job = job;
    }

    private void wrapAssertion(Runnable assertion) {
        if (this.hasFailed) {
            return;
        }
        try {
            assertion.run();
        }
        catch (AssertionError error) {
            this.processFailedAssertion(error);
        }
    }

    public void processFailedAssertion(AssertionError assertionError) throws FussyProgressAssertionFailed {
        this.hasFailed = true;
        Object jobSuffix = "";
        if (this.job != null) {
            jobSuffix = (String)jobSuffix + " in job: " + this.job.getName();
        }
        FussyProgressAssertionFailed failure = new FussyProgressAssertionFailed("Progress monitor assertion failed" + (String)jobSuffix);
        failure.initCause((Throwable)((Object)assertionError));
        throw failure;
    }

    public void assertUsedUp() {
        this.wrapAssertion(() -> {
            AbstractBooleanAssert abstractBooleanAssert = ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.beginTaskCalled).withFailMessage("beginTask has not been called on ProgressMonitor", new Object[0])).isTrue();
        });
        this.wrapAssertion(() -> {
            AbstractLongAssert abstractLongAssert = ((AbstractLongAssert)Assertions.assertThat((long)Math.round(this.workedSoFar)).as("work done", new Object[0])).isGreaterThanOrEqualTo((long)this.totalWork);
        });
    }

    @Override
    public void beginTask(String name, int newTotalWork) {
        this.wrapAssertion(() -> {
            AbstractBooleanAssert abstractBooleanAssert = ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.beginTaskCalled).withFailMessage("beginTask may only be called once (old name=%s)", new Object[]{this.taskName})).isFalse();
        });
        this.beginTaskCalled = true;
        this.taskName = name;
        this.wrapAssertion(() -> {
            AbstractAssert abstractAssert = ((AbstractIntegerAssert)Assertions.assertThat((int)newTotalWork).as("total work", new Object[0])).satisfiesAnyOf(new ThrowingConsumer[]{work -> {
                AbstractIntegerAssert abstractIntegerAssert = Assertions.assertThat((Integer)work).isEqualTo(-1);
            }, work -> {
                AbstractIntegerAssert abstractIntegerAssert = Assertions.assertThat((Integer)work).isGreaterThan(0);
            }});
        });
        this.totalWork = newTotalWork;
        this.beginTime = System.currentTimeMillis();
    }

    @Override
    public void done() {
        this.workedSoFar = this.totalWork;
        ++this.doneCalls;
    }

    @Override
    public void internalWorked(double work) {
        this.wrapAssertion(() -> {
            AbstractBooleanAssert abstractBooleanAssert = ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.beginTaskCalled).withFailMessage("can accept calls to worked/internalWorked only after beginTask", new Object[0])).isTrue();
        });
        this.wrapAssertion(() -> {
            AbstractIntegerAssert abstractIntegerAssert = ((AbstractIntegerAssert)Assertions.assertThat((int)this.doneCalls).withFailMessage("can accept calls to worked/internalWorked only before done is called", new Object[0])).isZero();
        });
        this.wrapAssertion(() -> {
            AbstractDoubleAssert abstractDoubleAssert = ((AbstractDoubleAssert)Assertions.assertThat((double)work).as("amount worked", new Object[0])).isGreaterThan(0.0);
        });
        this.workedSoFar += work;
        if (this.totalWork != -1) {
            this.wrapAssertion(() -> {
                AbstractDoubleAssert abstractDoubleAssert = ((AbstractDoubleAssert)Assertions.assertThat((double)this.workedSoFar).as("total work done", new Object[0])).isLessThanOrEqualTo((double)this.totalWork + (double)this.totalWork * 0.01);
            });
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    public void prepare() {
        this.sanityCheckCalled = false;
        this.taskName = null;
        this.totalWork = 0;
        this.workedSoFar = 0.0;
        this.beginTaskCalled = false;
        this.doneCalls = 0;
        this.hasFailed = false;
    }

    public void sanityCheck() {
        this.wrapAssertion(() -> {
            AbstractBooleanAssert abstractBooleanAssert = ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.sanityCheckCalled).withFailMessage("sanityCheck has already been called", new Object[0])).isFalse();
        });
        this.sanityCheckCalled = true;
        long duration = System.currentTimeMillis() - this.beginTime;
        if (duration > 1000L && this.beginTaskCalled) {
            this.wrapAssertion(() -> {
                AbstractDoubleAssert abstractDoubleAssert = ((AbstractDoubleAssert)Assertions.assertThat((double)this.workedSoFar).withFailMessage("this operation took: %s ms, it should report progress", new Object[]{duration})).isGreaterThan(0.0);
            });
        }
    }

    @Override
    public void setCanceled(boolean b) {
        boolean wasCanceled = this.isCanceled();
        this.canceled = b;
        if (this.canceled && !wasCanceled && this.job != null) {
            this.job.cancel();
        }
    }

    @Override
    public void setTaskName(String name) {
        this.taskName = name;
    }

    @Override
    public void subTask(String name) {
    }

    @Override
    public void worked(int work) {
        this.internalWorked(work);
    }

    public static class FussyProgressAssertionFailed
    extends AssertionFailedError {
        private static final long serialVersionUID = 1L;

        FussyProgressAssertionFailed(String name) {
            super(name);
        }
    }
}

