/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.eclipse.core.tests.harness.PerformanceTimer;

public class PerformanceTestResult
extends TestResult {
    protected PrintWriter output;
    protected ArrayList<PerformanceTimer> timerList = new ArrayList();
    protected HashMap<String, PerformanceTimer> timers = new HashMap();

    public PerformanceTestResult() {
        this(new PrintWriter(System.out));
    }

    public PerformanceTestResult(PrintWriter outputStream) {
        this.output = outputStream;
    }

    public synchronized void endTest(Test test) {
        this.print();
    }

    public synchronized void print() {
        this.stopTimers();
        this.printHeader(this.output);
        this.printErrors(this.output);
        this.printFailures(this.output);
        this.printTimings(this.output);
    }

    protected void printErrors(PrintWriter out) {
        int count = this.errorCount();
        if (count != 0) {
            if (count == 1) {
                out.println("There was " + count + " error:");
            } else {
                out.println("There were " + count + " errors:");
            }
            int i = 1;
            Enumeration e = this.errors();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                out.println(i + ") " + String.valueOf(failure.failedTest()));
                failure.thrownException().printStackTrace(out);
                ++i;
            }
        }
    }

    protected void printFailures(PrintWriter out) {
        int count = this.failureCount();
        if (count != 0) {
            if (count == 1) {
                out.println("There was " + count + " failure:");
            } else {
                out.println("There were " + count + " failures:");
            }
            int i = 1;
            Enumeration e = this.failures();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                out.println(i + ") " + String.valueOf(failure.failedTest()));
                failure.thrownException().printStackTrace(out);
                ++i;
            }
        }
    }

    protected void printHeader(PrintWriter out) {
        if (this.wasSuccessful()) {
            out.println();
            out.print("OK");
            out.println(" (" + this.runCount() + " tests)");
        } else {
            out.println();
            out.println("!!!FAILURES!!!");
            out.println("Test Results:");
            out.println("Run: " + this.runCount() + " Failures: " + this.failureCount() + " Errors: " + this.errorCount());
        }
    }

    protected void printTimings(PrintWriter out) {
        for (PerformanceTimer timer : this.timerList) {
            out.println("Timing " + timer.getName() + " : " + timer.getElapsedTime() + " ms ");
        }
    }

    public synchronized void startTest(Test test) {
        super.startTest(test);
        System.out.print(".");
    }

    public synchronized void startTimer(String timerName) {
        PerformanceTimer timer = this.timers.get(timerName);
        if (timer == null) {
            timer = new PerformanceTimer(timerName);
            this.timers.put(timerName, timer);
            this.timerList.add(timer);
        }
        timer.startTiming();
    }

    public synchronized void stopTimer(String timerName) {
        PerformanceTimer timer = this.timers.get(timerName);
        if (timer == null) {
            throw new Error(timerName + " is not a valid timer name ");
        }
        timer.stopTiming();
    }

    protected void stopTimers() {
        for (PerformanceTimer performanceTimer : this.timerList) {
            performanceTimer.stopTiming();
        }
    }
}

